/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.environment;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.Entity;
import org.hibernate.proxy.HibernateProxy;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.server.ServerHB;
import org.qubership.automation.itf.core.model.jpa.transport.EciConfiguration;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.ei.deserialize.TransportConfigurationDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.helper.StorableUtils;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=InboundTransportConfiguration.class)
public class InboundTransportConfiguration
extends EciConfiguration
implements EciConfigurable {
    private static final long serialVersionUID = 20240812L;
    private TransportConfiguration referencedConfiguration;
    private Set<TriggerConfiguration> triggerConfigurations = Sets.newHashSetWithExpectedSize((int)5);

    public InboundTransportConfiguration() {
    }

    public InboundTransportConfiguration(TransportConfiguration referencedConfiguration, Server parent) {
        this.setParent((ServerHB)parent);
        this.setReferencedConfiguration(referencedConfiguration);
    }

    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only TransportConfiguration objects are here")
    public TransportConfiguration getReferencedConfiguration() {
        return this.referencedConfiguration instanceof HibernateProxy ? (TransportConfiguration)((HibernateProxy)this.referencedConfiguration).getHibernateLazyInitializer().getImplementation() : this.referencedConfiguration;
    }

    @JsonDeserialize(using=TransportConfigurationDeserializer.class)
    public void setReferencedConfiguration(TransportConfiguration referencedConfiguration) {
        this.referencedConfiguration = referencedConfiguration;
        this.setTypeName(referencedConfiguration.getTypeName());
        this.setName(String.format("%s at %s", referencedConfiguration.getName(), this.getParent().getName()));
    }

    public Set<TriggerConfiguration> getTriggerConfigurations() {
        return this.triggerConfigurations;
    }

    protected void setTriggerConfigurations(Set<TriggerConfiguration> triggerConfigurations) {
        this.triggerConfigurations = triggerConfigurations;
    }

    public void fillTriggerConfigurations(Set<TriggerConfiguration> triggerConfigurations) {
        StorableUtils.fillCollection(this.getTriggerConfigurations(), triggerConfigurations);
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public ServerHB getParent() {
        return (ServerHB)super.getParent();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=ServerHB.class)
    public void setParent(ServerHB parent) {
        super.setParent(parent);
    }

    @Override
    public void unbindEntityWithHierarchy() {
        this.setEciParameters(null, null);
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.triggerConfigurations.forEach((? super T triggerConfiguration) -> triggerConfiguration.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }
}

