/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.environment;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.math.BigInteger;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.eci.EciConfigurable;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.server.ServerHB;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.EciConfiguration;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.ei.deserialize.SystemDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=OutboundTransportConfiguration.class)
public class OutboundTransportConfiguration
extends EciConfiguration
implements EciConfigurable {
    private static final long serialVersionUID = 20240812L;
    private System system;
    private String typeName;

    public OutboundTransportConfiguration() {
    }

    public OutboundTransportConfiguration(String type, Server parent, System system) {
        this.setParent((ServerHB)parent);
        this.setTypeName(type);
        this.setSystem(system);
    }

    @JsonSerialize(using=IdSerializer.class)
    public System getSystem() {
        return this.system;
    }

    @JsonDeserialize(using=SystemDeserializer.class)
    public void setSystem(System system) {
        this.system = system;
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public ServerHB getParent() {
        return (ServerHB)super.getParent();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=ServerHB.class)
    public void setParent(ServerHB parent) {
        super.setParent(parent);
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
        this.getSystem().performPostImportActions(projectId, sessionId);
    }

    @Override
    public void unbindEntityWithHierarchy() {
        this.setEciParameters(null, null);
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
    }
}

