/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.environment;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.ei.deserialize.TriggerStateDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true, value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=TriggerConfiguration.class)
public class TriggerConfiguration
extends Configuration {
    private static final long serialVersionUID = 20240812L;
    private TriggerState state;
    private String activationErrorMessage;

    public TriggerConfiguration() {
    }

    @Deprecated
    public TriggerConfiguration(InboundTransportConfiguration parent) {
        this.setParent(parent);
        this.setTypeName(parent.getTypeName());
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only InboundTransportConfiguration objects are here")
    public TriggerConfiguration(Storable parent) {
        this.setParent(parent);
        ((InboundTransportConfiguration)parent).getTriggerConfigurations().add(this);
    }

    public TriggerConfiguration(String typeName) {
        super(typeName);
    }

    @JsonDeserialize(using=TriggerStateDeserializer.class)
    public void setState(TriggerState state) {
        this.state = state;
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public InboundTransportConfiguration getParent() {
        return (InboundTransportConfiguration)super.getParent();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=InboundTransportConfiguration.class)
    public void setParent(InboundTransportConfiguration parent) {
        super.setParent(parent);
    }

    @Override
    public String getTypeName() {
        return this.getParent() != null ? this.getParent().getTypeName() : super.getTypeName();
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
    }

    public TriggerState getState() {
        return this.state;
    }

    public String getActivationErrorMessage() {
        return this.activationErrorMessage;
    }

    public void setActivationErrorMessage(String activationErrorMessage) {
        this.activationErrorMessage = activationErrorMessage;
    }
}

