/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.folder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.AbstractConfiguration;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.folder.ChainFolder;
import org.qubership.automation.itf.core.model.jpa.folder.EnvFolder;
import org.qubership.automation.itf.core.model.jpa.folder.ServerFolder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdsListSerializer;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;

@Entity
public class Folder<T extends Storable>
extends AbstractConfiguration<String, String> {
    private static final long serialVersionUID = 20240812L;
    private final Class<T> genericType;
    private List<T> objects = Lists.newArrayListWithExpectedSize((int)50);
    @Transient
    private List<Folder<T>> subFolders = Lists.newArrayListWithExpectedSize((int)50);
    @JsonIgnore
    private StubProject project;

    @Transient
    @JsonIgnore
    public int hierarchyLevel() {
        Storable current = this;
        int level = 0;
        while (current.getParent() != null) {
            ++level;
            current = current.getParent();
        }
        return level;
    }

    @Deprecated
    public Folder() {
        this.genericType = null;
    }

    public Folder(Class<T> genericType) {
        this.genericType = genericType;
    }

    public Class<T> getGenericType() {
        return this.genericType;
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public Storable getParent() {
        return super.getParent();
    }

    @Override
    @JsonIgnore
    public void setParent(Storable parent) {
        super.setParent(parent);
    }

    @RefCopy
    public StubProject getProject() {
        if (this.project == null && this.getParent() != null && this.getParent() instanceof Folder) {
            return ((Folder)this.getParent()).getProject();
        }
        return this.project;
    }

    @Override
    public BigInteger getProjectId() {
        return (BigInteger)this.getProject().getID();
    }

    public void setProject(StubProject project) {
        this.project = project;
    }

    @JsonSerialize(using=IdsListSerializer.class)
    public List<T> getObjects() {
        return this.objects;
    }

    protected void setObjects(List<T> objects) {
        this.objects = objects;
    }

    public void fillObjects(Collection<T> objects) {
        StorableUtils.fillCollection(this.getObjects(), objects);
    }

    @JsonSerialize(using=IdsListSerializer.class)
    public List<Folder<T>> getSubFolders() {
        return this.subFolders;
    }

    protected void setSubFolders(List<Folder<T>> subFolders) {
        this.subFolders = subFolders;
    }

    public void fillSubFolders(Collection<Folder<T>> subFolders) {
        StorableUtils.fillCollection(this.getSubFolders(), subFolders);
    }

    @JsonIgnore
    public Collection<Folder<T>> getFullPath() {
        Storable parent = this.getParent();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        result.add(this);
        while (parent instanceof Folder) {
            result.add((Folder)parent);
            parent = parent.getParent();
        }
        return result;
    }

    @Override
    @JsonIgnore
    protected ObjectManager getManager() {
        return CoreObjectManager.getInstance().getManager(Folder.class);
    }

    @Nonnull
    public <S extends Storable> Optional<Folder<S>> of(@Nonnull Class<S> objectType) {
        if (objectType.equals(this.genericType)) {
            return Optional.of((Object)this);
        }
        return Optional.absent();
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
        if (this instanceof ChainFolder) {
            for (CallChain callChain : ((ChainFolder)this).getObjects()) {
                callChain.performPostImportActions(projectId, sessionId);
            }
        } else if (this instanceof EnvFolder) {
            for (Environment environment : ((EnvFolder)this).getObjects()) {
                environment.performPostImportActions(projectId, sessionId);
            }
        }
        for (Object object : this.getSubFolders()) {
            ((Folder)object).performPostImportActions(projectId, sessionId);
        }
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.getSubFolders().forEach((? super T folder) -> folder.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }

    @Override
    public Storable findRootObject(BigInteger projectId) {
        StubProject project = CoreObjectManager.getInstance().getManager(StubProject.class).getById(projectId);
        ObjectManager<Folder> folderManager = CoreObjectManager.getInstance().getManager(Folder.class);
        if (this instanceof ChainFolder) {
            return folderManager.getById(project.getCallchains().getID());
        }
        if (this instanceof EnvFolder) {
            return folderManager.getById(project.getEnvironments().getID());
        }
        if (this instanceof SystemFolder) {
            return folderManager.getById(project.getSystems().getID());
        }
        if (this instanceof ServerFolder) {
            return project.getServers();
        }
        return null;
    }
}

