/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.instance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Entity;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.extension.ExtendableImpl;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.util.annotation.JsonRef;
import org.qubership.automation.itf.core.util.constants.Status;

@Entity
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SituationInstance.class, name="SituationInstance"), @JsonSubTypes.Type(value=CallChainInstance.class, name="CallChainInstance"), @JsonSubTypes.Type(value=StepInstance.class, name="StepInstance")})
public abstract class AbstractInstance
extends ExtendableImpl {
    private Status status;
    private Date startTime;
    private Date endTime;
    private InstanceContext context = new InstanceContext(this);
    private Throwable error;
    private String errorName;
    private String errorMessage;
    private AbstractInstance parent;
    private Integer partNum;

    public AbstractInstance() {
        this.status = Status.NOT_STARTED;
    }

    @JsonIgnore
    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
        this.errorName = error.getMessage();
        this.errorMessage = ExceptionUtils.getStackTrace((Throwable)error);
    }

    public boolean isRunning() {
        return Status.IN_PROGRESS.equals((Object)this.status);
    }

    public boolean isFinished() {
        return Status.FAILED.equals((Object)this.status) || Status.PASSED.equals((Object)this.status) || Status.STOPPED.equals((Object)this.status) || Status.FAILED_BY_TIMEOUT.equals((Object)this.status);
    }

    @JsonRef
    public abstract Storable getSource();

    public Map<String, String> getTransportConfiguration() {
        return new HashMap<String, String>();
    }

    @Override
    public String toString() {
        return String.format("Instance{%s}", this.getSource());
    }

    public void destroy() {
        this.context = null;
        this.protectedDestroy();
    }

    protected void protectedDestroy() {
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public InstanceContext getContext() {
        return this.context;
    }

    public String getErrorName() {
        return this.errorName;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public AbstractInstance getParent() {
        return this.parent;
    }

    public Integer getPartNum() {
        return this.partNum;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setContext(InstanceContext context) {
        this.context = context;
    }

    public void setErrorName(String errorName) {
        this.errorName = errorName;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setParent(AbstractInstance parent) {
        this.parent = parent;
    }

    public void setPartNum(Integer partNum) {
        this.partNum = partNum;
    }
}

