/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.instance;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.iterator.StepIterator;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;

@Entity
@JsonFilter(value="reportWorkerFilter_SituationInstance")
public class SituationInstance
extends AbstractContainerInstance {
    private static final long serialVersionUID = 20240812L;
    private BigInteger situationId;
    private String operationName;
    private BigInteger operationId;
    private BigInteger systemId;
    private String systemName;
    private StepIterator iterator = null;

    public SituationInstance() {
    }

    @Override
    public Storable getSource() {
        return this.getStepContainer();
    }

    public SituationInstance(BigInteger situationId, InstanceContext instanceContext) {
        this.situationId = situationId;
        this.getContext().putAll((Map)instanceContext);
    }

    @Transient
    @JsonIgnore
    public Situation getSituationById() {
        return Objects.nonNull(this.situationId) ? CoreObjectManager.getInstance().getManager(Situation.class).getById(this.getSituationId()) : null;
    }

    @Override
    public StepIterator iterator() {
        if (this.iterator == null) {
            this.iterator = new StepIterator(this.getSituationById() == null ? Collections.emptyList() : this.getSituationById().getSteps(), this);
        }
        return this.iterator;
    }

    public void setIterator(StepIterator iterator) {
        this.iterator = iterator;
    }

    @Override
    public StepContainer getStepContainer() {
        return this.getSituationById();
    }

    @Override
    public void setStepContainer(StepContainer container) {
        this.situationId = (BigInteger)container.getID();
    }

    @JsonIgnore
    public List<String> getLabels() {
        return this.getSituationById() == null ? Collections.emptyList() : this.getSituationById().getLabels();
    }

    public BigInteger getSituationId() {
        return this.situationId;
    }

    public void setSituationId(BigInteger situationId) {
        this.situationId = situationId;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public BigInteger getOperationId() {
        return this.operationId;
    }

    public void setOperationId(BigInteger operationId) {
        this.operationId = operationId;
    }

    public BigInteger getSystemId() {
        return this.systemId;
    }

    public void setSystemId(BigInteger systemId) {
        this.systemId = systemId;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }
}

