/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.message.parser;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;

@Entity
@JsonFilter(value="reportWorkerFilter_MessageParameter")
public class MessageParameter
extends AbstractStorable {
    private static final long serialVersionUID = 20240812L;
    @JsonIgnore
    private Storable parent;
    private String paramName;
    private List<String> multipleValue;
    private boolean multiple;
    private boolean autosave;

    private MessageParameter() {
    }

    public static Builder build(String paramName, ParsingRule rule) {
        Builder builder = new Builder();
        builder.paramName = paramName;
        return builder;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getSingleValue() {
        return this.multipleValue.get(0);
    }

    public List<String> getMultipleValue() {
        return this.multipleValue;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isAutosave() {
        return this.autosave;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setMultipleValue(List<String> multipleValue) {
        this.multipleValue = multipleValue;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setAutosave(boolean autosave) {
        this.autosave = autosave;
    }

    @Override
    public String toString() {
        return String.format("%s / %s [id: %s]", this.getParent().getClass().getSimpleName(), this.paramName, this.getID());
    }

    public static class Builder {
        private String paramName;
        private List<String> multipleValue = Lists.newArrayListWithExpectedSize((int)10);
        private boolean multiple = false;
        private boolean autosave = false;

        private Builder() {
        }

        public Builder setAutosave(boolean autosave) {
            this.autosave = autosave;
            return this;
        }

        public Builder singleValue(String singleValue) {
            this.multipleValue.clear();
            this.multipleValue.add(singleValue);
            return this;
        }

        public Builder multipleValue(String value) {
            this.multipleValue.add(value);
            return this;
        }

        public Builder multiple(boolean multiple) {
            this.multiple = multiple;
            return this;
        }

        public MessageParameter get() {
            MessageParameter parameter = new MessageParameter();
            parameter.paramName = this.paramName;
            parameter.multiple = this.multiple;
            parameter.multipleValue = this.multipleValue;
            parameter.autosave = this.autosave;
            return parameter;
        }
    }
}

