/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.message.template;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.model.common.Named;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.jpa.interceptor.TemplateInterceptor;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.template.OutboundTemplateTransportConfiguration;
import org.qubership.automation.itf.core.util.annotation.ProduceNewObject;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.holder.ActiveInterceptorHolder;
import org.qubership.automation.itf.core.util.provider.InterceptorProvider;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public abstract class AbstractTemplate<T extends TemplateProvider>
extends LabeledStorable
implements Template<T>,
Named,
InterceptorProvider {
    private String text;
    private Object contentFile;
    private Map<String, String> headers = Maps.newHashMapWithExpectedSize((int)5);
    private Collection<OutboundTemplateTransportConfiguration> transportProperties = Lists.newArrayList();
    private Set<String> compatibleWithTransports = Sets.newHashSetWithExpectedSize((int)2);
    private List<Interceptor> interceptors = Lists.newLinkedList();
    private BigInteger projectId;
    private T parent;

    public AbstractTemplate(T parent) {
        if (parent != null) {
            this.setName("New Template");
            parent.returnTemplates().add(this);
            this.setParent(parent);
            this.setProjectId(parent.getProjectId());
        }
    }

    @Override
    @JsonManagedReference
    public Collection<OutboundTemplateTransportConfiguration> getTransportProperties() {
        return this.transportProperties;
    }

    @Override
    @JsonIgnore
    @Nullable
    public OutboundTemplateTransportConfiguration getTransportProperties(@Nonnull String typeName) {
        return (OutboundTemplateTransportConfiguration)Iterables.tryFind(this.getTransportProperties(), input -> typeName.equals(input.getTypeName())).orNull();
    }

    @Override
    @JsonSerialize(contentAs=TemplateInterceptor.class)
    @JsonManagedReference
    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    @JsonDeserialize(contentAs=TemplateInterceptor.class)
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void setText(String text) {
        this.text = text != null ? text : "";
    }

    @Override
    @ProduceNewObject
    public Object getNaturalId() {
        return super.getNaturalId();
    }

    @Override
    public void fillHeaders(Map<String, String> headers) {
        StorableUtils.fillMap(this.getHeaders(), headers);
    }

    @Override
    public void fillTransportProperties(Collection<OutboundTemplateTransportConfiguration> transportProperties) {
        StorableUtils.fillCollection(this.getTransportProperties(), transportProperties);
    }

    public void fillCompatibleWithTransports(Set<String> compatibleWithTransports) {
        StorableUtils.fillCollection(this.getCompatibleWithTransports(), compatibleWithTransports);
    }

    @Override
    public void performPostCopyActions(boolean statusOff) {
        if (statusOff) {
            for (Interceptor interceptor : this.interceptors) {
                interceptor.setActive(false);
            }
        } else {
            ActiveInterceptorHolder.getInstance().updateActiveInterceptorHolder(this.getID(), this.interceptors);
        }
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.getTransportProperties().forEach(transportProperty -> transportProperty.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        this.getInterceptors().forEach(interceptor -> interceptor.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }

    @Override
    public String getText() {
        return this.text;
    }

    public Object getContentFile() {
        return this.contentFile;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Set<String> getCompatibleWithTransports() {
        return this.compatibleWithTransports;
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }

    @Override
    public T getParent() {
        return this.parent;
    }

    public void setContentFile(Object contentFile) {
        this.contentFile = contentFile;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public void setTransportProperties(Collection<OutboundTemplateTransportConfiguration> transportProperties) {
        this.transportProperties = transportProperties;
    }

    @Override
    public void setCompatibleWithTransports(Set<String> compatibleWithTransports) {
        this.compatibleWithTransports = compatibleWithTransports;
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }

    @Override
    public void setParent(T parent) {
        this.parent = parent;
    }

    public AbstractTemplate() {
    }
}

