/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.project;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.transport.Configuration;
import org.qubership.automation.itf.core.util.annotation.RefCopy;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=IntegrationConfig.class)
public class IntegrationConfig
extends Configuration {
    private static final long serialVersionUID = 20240812L;
    private String toolName;
    private Map<String, String> properties = Maps.newHashMapWithExpectedSize((int)10);

    public IntegrationConfig() {
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only StubProject objects are here")
    public IntegrationConfig(Storable parent, String name, String type) {
        this.setName(name);
        this.setTypeName(type);
        this.setParent(parent);
        ((StubProject)parent).getIntegrationConfs().add(this);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only StubProject objects are here")
    public IntegrationConfig(Storable parent, Map parameters) {
        this.setParent(parent);
        ((StubProject)parent).getIntegrationConfs().add(this);
        if (parameters != null) {
            this.putAll(parameters);
        }
    }

    @Override
    @RefCopy
    @JsonIgnore
    public StubProject getParent() {
        return (StubProject)super.getParent();
    }

    @JsonIgnore
    public void setParent(StubProject parent) {
        super.setParent(parent);
    }

    @Override
    public String getName() {
        return this.toolName;
    }

    @Override
    public void setName(String name) {
        this.setToolName(name);
    }

    public String getToolName() {
        return this.toolName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

