/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.step;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.step.AbstractCallChainStep;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.ei.deserialize.NestedChainDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true, value={"hibernateLazyInitializer", "handler"})
public class EmbeddedStep
extends AbstractCallChainStep {
    private static final long serialVersionUID = 20240812L;
    @JsonProperty(value="type")
    public static final String TYPE = "embeddedChainStep";
    private CallChain chain;

    public EmbeddedStep() {
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only StepContainer objects are here")
    public EmbeddedStep(Storable parent) {
        this.setParent(parent);
        ((StepContainer)parent).getSteps().add(this);
    }

    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public CallChain getChain() {
        return this.chain;
    }

    @JsonDeserialize(using=NestedChainDeserializer.class)
    public void setChain(CallChain chain) {
        this.chain = chain;
    }

    @Override
    @JsonIgnore
    public Mep getMep() {
        return Mep.OUTBOUND_REQUEST_ASYNCHRONOUS;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return "EmbeddedStep{chain=" + this.chain + '}';
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        this.setLastOrderToImportedStep(this.getParent());
        super.performPostImportActions(projectId, sessionId);
        CallChain embeddedCallchain = this.getChain();
        if (embeddedCallchain != null) {
            embeddedCallchain.performPostImportActions(projectId, sessionId);
        }
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public CallChain getParent() {
        return (CallChain)super.getParent();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=CallChain.class)
    public void setParent(CallChain parent) {
        super.setParent(parent);
    }
}

