/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.step;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.Transient;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.jpa.message.template.OperationTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.step.AbstractStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.annotation.OperationRefCopyAsNewObject;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.annotation.TemplateRefCopyAsNewObject;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.ei.deserialize.SystemDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true, value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=IntegrationStep.class)
public class IntegrationStep
extends AbstractStep {
    private static final long serialVersionUID = 20240812L;
    @JsonProperty(value="type")
    public static final String TYPE = "integrationStep";
    private System sender;
    private System receiver;
    private Operation operation;
    private SystemTemplate systemTemplate;
    private OperationTemplate operationTemplate;
    private boolean retryOnFail = false;
    private long retryTimeout;
    private String retryTimeoutUnit = TimeUnit.SECONDS.toString();
    private int validationMaxAttempts;
    private long validationMaxTime;
    private String validationUnitMaxTime = TimeUnit.SECONDS.toString();

    public IntegrationStep() {
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only StepContainer objects are here")
    public IntegrationStep(Storable parent) {
        this.setParent(parent);
        ((StepContainer)parent).getSteps().add(this);
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public Situation getParent() {
        return (Situation)super.getParent();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=Situation.class)
    public void setParent(Situation parent) {
        super.setParent(parent);
    }

    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public System getSender() {
        return this.sender;
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=System.class)
    public void setSender(System sender) {
        this.sender = sender;
    }

    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public System getReceiver() {
        return this.receiver;
    }

    @JsonDeserialize(using=SystemDeserializer.class)
    public void setReceiver(System receiver) {
        this.receiver = receiver;
    }

    @TemplateRefCopyAsNewObject
    @JsonSerialize(using=IdSerializer.class)
    public SystemTemplate getSystemTemplate() {
        return this.systemTemplate;
    }

    @TemplateRefCopyAsNewObject
    @JsonSerialize(using=IdSerializer.class)
    public OperationTemplate getOperationTemplate() {
        return this.operationTemplate;
    }

    @JsonIgnore
    public Template returnStepTemplate() {
        return this.systemTemplate != null ? this.systemTemplate : this.operationTemplate;
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=SystemTemplate.class)
    public void setSystemTemplate(SystemTemplate systemTemplate) {
        this.systemTemplate = systemTemplate;
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=OperationTemplate.class)
    public void setOperationTemplate(OperationTemplate operationTemplate) {
        this.operationTemplate = operationTemplate;
    }

    @JsonIgnore
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Only OperationTemplate objects are here")
    public void setTemplate(Template template) {
        if (template instanceof SystemTemplate) {
            if (this.getOperationTemplate() != null) {
                this.setOperationTemplate(null);
            }
            this.setSystemTemplate((SystemTemplate)template);
        } else {
            if (this.getSystemTemplate() != null) {
                this.setSystemTemplate(null);
            }
            this.setOperationTemplate((OperationTemplate)template);
        }
    }

    @OperationRefCopyAsNewObject
    @JsonSerialize(using=IdSerializer.class)
    public Operation getOperation() {
        return this.operation;
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=Operation.class)
    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public boolean isRetryOnFail() {
        return this.retryOnFail;
    }

    public void setRetryOnFail(boolean retryOnFail) {
        this.retryOnFail = retryOnFail;
    }

    public long getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public String getRetryTimeoutUnit() {
        return this.retryTimeoutUnit;
    }

    public void setRetryTimeoutUnit(String retryTimeoutUnit) {
        this.retryTimeoutUnit = IntegrationStep.checkUnit(retryTimeoutUnit);
    }

    @Transient
    @JsonIgnore
    public TimeUnit retrieveRetryTimeoutUnit() {
        return IntegrationStep.convertToTimeUnit(this.retryTimeoutUnit);
    }

    public int getValidationMaxAttempts() {
        return this.validationMaxAttempts;
    }

    public void setValidationMaxAttempts(int validationMaxAttempts) {
        this.validationMaxAttempts = validationMaxAttempts;
    }

    public long getValidationMaxTime() {
        return this.validationMaxTime;
    }

    public void setValidationMaxTime(long validationMaxTime) {
        this.validationMaxTime = validationMaxTime;
    }

    public String getValidationUnitMaxTime() {
        return this.validationUnitMaxTime;
    }

    public void setValidationUnitMaxTime(String validationUnitMaxTime) {
        this.validationUnitMaxTime = IntegrationStep.checkUnit(validationUnitMaxTime);
    }

    @Transient
    @JsonIgnore
    public TimeUnit retrieveValidationUnitMaxTime() {
        return IntegrationStep.convertToTimeUnit(this.validationUnitMaxTime);
    }

    @Override
    public Mep getMep() {
        if (this.operation != null) {
            return this.operation.getMep();
        }
        return Mep.OUTBOUND_REQUEST_ASYNCHRONOUS;
    }

    @Override
    @JsonIgnore
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IntegrationStep)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (((IntegrationStep)obj).getOperation() == null) {
            return this.operation == null;
        }
        return ((IntegrationStep)obj).getOperation().equals(this.operation);
    }

    @Override
    public int hashCode() {
        return this.getID().hashCode();
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
    }
}

