/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.storage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PreRemove;
import org.apache.commons.lang3.NotImplementedException;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.jpa.common.AbstractNamedImpl;
import org.qubership.automation.itf.core.model.usage.UsageInfo;
import org.qubership.automation.itf.core.util.annotation.NoCopy;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.db.ItfTransactionSynchAdapter;
import org.qubership.automation.itf.core.util.ei.deserialize.DeserializedEntitiesCache;
import org.qubership.automation.itf.core.util.exception.CopyException;
import org.qubership.automation.itf.core.util.exception.NoSuchManagerException;
import org.qubership.automation.itf.core.util.exception.StorageException;
import org.qubership.automation.itf.core.util.generator.id.UniqueIdGenerator;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.storage.StoreDelegateFactory;
import org.qubership.automation.itf.core.util.storage.StoreInformationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractStorable
extends AbstractNamedImpl
implements Storable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractStorable.class);
    private static final String SIMPLE_PARENT_MARKER = "#SimpleParent#";
    private Storable parent;
    private StoreInformationDelegate storeInformationDelegate = StoreDelegateFactory.getInstance().newDelegate();
    private String prefix;
    private String description;
    private Object naturalId;
    private Map<String, String> storableProp;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public AbstractStorable() {
    }

    @Override
    public void store() throws StorageException {
        this.getManager().store(this);
        LOGGER.info("Storable {} stored", (Object)this);
    }

    @Override
    public void replicate() {
        this.getManager().replicate(this);
        LOGGER.info("Storable {} replicated", (Object)this);
    }

    public void update() {
        this.getManager().update(this);
        LOGGER.info("Storable {} updated", (Object)this);
    }

    @Override
    public boolean contains() {
        return this.getManager().contains(this);
    }

    @Override
    public void flush() {
        this.getManager().flush();
    }

    protected String printStackTrace() {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            builder.append(stackTraceElement.toString()).append('\n');
        }
        return builder.toString();
    }

    @Override
    public Collection<UsageInfo> remove() throws StorageException {
        return this.getManager().remove(this, true);
    }

    @Override
    public void move(Storable newParent) {
        this.getManager().move(newParent, this, "");
    }

    @Override
    public Storable copy(Storable newParent) throws CopyException {
        return this.getManager().copy(newParent, this, "", "");
    }

    @Override
    public Collection<UsageInfo> findUsages() {
        return this.getManager().findUsages(this);
    }

    @Override
    @RefCopy
    public Storable getParent() {
        return this.parent;
    }

    @Override
    public Storable returnSimpleParent() {
        if (this.parent != null) {
            try {
                Storable simpleStorable = (Storable)this.parent.getClass().newInstance();
                simpleStorable.setID(this.parent.getID());
                simpleStorable.setName(this.parent.getName());
                simpleStorable.setDescription(SIMPLE_PARENT_MARKER);
                simpleStorable.setVersion(this.parent.getVersion());
                simpleStorable.setNaturalId(this.parent.getNaturalId());
                simpleStorable.setParent(this.parent.returnSimpleParent());
                return simpleStorable;
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error("Can't create the object of {}. Null is returned.", (Object)this.parent.getClass().getName(), (Object)e);
                return null;
            }
        }
        LOGGER.debug("Object [id {}, class {}] hasn't got a parent. Null is returned.", this.getID(), (Object)this.getClass().getName());
        return null;
    }

    @Override
    public Storable getExtendsParameters() {
        return null;
    }

    @Override
    public void setParent(Storable parent) {
        this.parent = parent;
    }

    @Override
    @NoCopy
    public Object getID() {
        return this.storeInformationDelegate.getID();
    }

    @Override
    public void setID(Object id) {
        this.storeInformationDelegate.setID(id);
    }

    @Override
    public Object getNaturalId() {
        return this.naturalId;
    }

    @Override
    public void setNaturalId(Object id) {
        this.naturalId = id;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    @NoCopy
    public Object getVersion() {
        return this.storeInformationDelegate.getVersion();
    }

    @Override
    public void setVersion(Object version) {
        Integer intVersion = null;
        if (version instanceof Integer) {
            intVersion = (Integer)version;
        } else if (version instanceof String) {
            intVersion = Integer.parseInt((String)version);
        }
        this.storeInformationDelegate.setVersion(intVersion);
    }

    @Override
    @JsonIgnore
    public StoreInformationDelegate getStoreInformationDelegate() {
        return this.storeInformationDelegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        if (this.getID() != null) {
            return Objects.equals(this.getID(), ((Storable)o).getID());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getID());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Storable parent = this.getParent(); parent != null; parent = parent.getParent()) {
            builder.insert(0, '>').insert(0, parent.getName()).insert(0, ']').insert(0, parent.getClass().getSimpleName()).insert(0, '[');
        }
        builder.append('\n').append("Name: '").append(this.getName()).append('\'').append(", ID: '").append(this.getID()).append('\'');
        return builder.toString();
    }

    protected ObjectManager getManager() {
        return CoreObjectManager.getInstance().getManager(this.getClass());
    }

    @PostPersist
    public void doAfterCreate() {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new ItfTransactionSynchAdapter(this){

            public void afterCommit() {
                try {
                    AbstractStorable.this.getManager().onCreate(this.getObject());
                }
                catch (NoSuchManagerException ignored) {
                    LOGGER.warn("NoSuchManagerException: ", (Throwable)ignored);
                }
            }
        });
    }

    @PostUpdate
    public void doAfterUpdate() {
        try {
            this.getManager().onUpdate(this);
        }
        catch (NoSuchManagerException ignored) {
            LOGGER.warn("NoSuchManagerException: ", (Throwable)ignored);
        }
    }

    @PreRemove
    public void doBeforeRemove() {
        try {
            this.getManager().onRemove(this);
        }
        catch (NoSuchManagerException noSuchManagerException) {
            // empty catch block
        }
    }

    @Override
    public void performPostCopyActions(boolean statusOff) {
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        DeserializedEntitiesCache.getInstance().getCacheBySessionId(sessionId).put((BigInteger)this.getID(), this);
        this.performPostImportActionsParent(projectId, sessionId);
    }

    @Override
    public void performPostImportActionsParent(BigInteger projectId, BigInteger sessionId) {
        if (this.getParent() != null) {
            Storable byId = DeserializedEntitiesCache.getInstance().getCacheBySessionId(sessionId).getById((BigInteger)this.getParent().getID());
            if (byId != null) {
                this.setParent(byId);
            } else {
                DeserializedEntitiesCache.getInstance().getCacheBySessionId(sessionId).put((BigInteger)this.getParent().getID(), this.getParent());
                this.getParent().performPostImportActionsParent(projectId, sessionId);
            }
        }
    }

    @Override
    public Map<String, String> getStorableProp() {
        return this.storableProp;
    }

    @Override
    public void setStorableProp(Map<String, String> storableProp) {
        this.storableProp = storableProp;
    }

    @Override
    public Storable findRootObject(BigInteger projectId) {
        throw new NotImplementedException("getRootObject is not applicable for the class");
    }

    @Override
    public void upStorableVersion() {
        this.setVersion((Object)((Integer)this.getVersion() + 1));
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        if (needToUpdateProjectId) {
            this.setProjectId(projectId);
        }
        if (needToGenerateNewId) {
            this.replaceStorableId(replacementMap);
        }
    }

    private void replaceStorableId(Map<BigInteger, BigInteger> replacementMap) {
        if (!replacementMap.containsValue((BigInteger)this.getID())) {
            BigInteger newId = (BigInteger)UniqueIdGenerator.generate();
            replacementMap.put((BigInteger)this.getID(), newId);
            this.setID(newId);
        }
    }
}

