/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.system;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.NativeManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.eci.AbstractEciConfigurable;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.folder.SystemFolder;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.SystemParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.SystemTemplate;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.StubContainer;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.annotation.ProduceNewObject;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.constants.SystemMode;
import org.qubership.automation.itf.core.util.ei.deserialize.SystemFolderDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;
import org.qubership.automation.itf.core.util.exception.OperationDefinitionException;
import org.qubership.automation.itf.core.util.helper.KeyHelper;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.KeyDefinitionProvider;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.core.util.provider.TemplateProvider;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=System.class)
public class System
extends AbstractEciConfigurable
implements ParsingRuleProvider,
KeyDefinitionProvider,
TemplateProvider {
    private static final long serialVersionUID = 20240812L;
    private Set<TransportConfiguration> transports = Sets.newHashSetWithExpectedSize((int)10);
    private Set<SystemParsingRule> systemParsingRules = Sets.newHashSetWithExpectedSize((int)20);
    private String outgoingContextKeyDefinition;
    private String incomingContextKeyDefinition;
    private String operationKeyDefinition;
    private Set<Operation> operations = Sets.newHashSetWithExpectedSize((int)20);
    private Set<SystemTemplate> systemTemplates = Sets.newHashSetWithExpectedSize((int)50);
    private SystemMode mode;
    private BigInteger projectId;

    public System() {
    }

    public System(Storable parent) {
        Folder<System> actualParent = this.determineActualParent(parent);
        this.setParent(actualParent);
        this.setProjectId(actualParent.getProjectId());
        actualParent.getObjects().add(this);
    }

    public System(Storable parent, String name, String type, String description, List<String> labels) {
        Folder<System> actualParent = this.determineActualParent(parent);
        this.setParent(actualParent);
        this.setProjectId(actualParent.getProjectId());
        this.setName(name);
        this.setDescription(description);
        this.setLabels(labels);
        actualParent.getObjects().add(this);
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public SystemFolder getParent() {
        return (SystemFolder)super.getParent();
    }

    @JsonDeserialize(using=SystemFolderDeserializer.class)
    public void setParent(SystemFolder parent) {
        super.setParent(parent);
    }

    @Override
    @JsonIgnore
    public Set<ParsingRule> returnParsingRules() {
        return this.systemParsingRules.stream().map(ParsingRule.class::cast).collect(Collectors.toSet());
    }

    @Override
    public void addParsingRule(ParsingRule parsingRule) {
        if (parsingRule instanceof SystemParsingRule) {
            this.systemParsingRules.add((SystemParsingRule)parsingRule);
        }
    }

    public void addParsingRule(SystemParsingRule rule) {
        this.systemParsingRules.add(rule);
    }

    @Override
    public void removeParsingRule(ParsingRule parsingRule) {
        this.systemParsingRules.remove(parsingRule);
    }

    @Override
    @JsonIgnore
    public Set<Template> returnTemplates() {
        return this.systemTemplates.stream().map(Template.class::cast).collect(Collectors.toSet());
    }

    private Folder<System> determineActualParent(Storable parent) {
        Optional<Folder<System>> systemFolder;
        Folder actualParent = null;
        if (parent instanceof StubContainer) {
            actualParent = ((StubContainer)((Object)parent)).getSystems();
        } else if (parent instanceof Folder && (systemFolder = ((Folder)parent).of(System.class)).isPresent()) {
            actualParent = (Folder)systemFolder.get();
        }
        if (actualParent == null) {
            throw new RuntimeException("SystemFolder or StubContainer are expected, but given: " + parent);
        }
        return actualParent;
    }

    public void addOperation(Operation operation) {
        if (this.operations == null) {
            this.operations = Sets.newHashSetWithExpectedSize((int)20);
        }
        this.operations.add(operation);
    }

    public void fillTransports(Set<TransportConfiguration> transports) {
        StorableUtils.fillCollection(this.getTransports(), transports);
    }

    public void addTransport(TransportConfiguration transports) {
        this.transports.add(transports);
    }

    public void fillOperations(Set<Operation> operations) {
        StorableUtils.fillCollection(this.getOperations(), operations);
    }

    public Operation defineOperation(InstanceContext context) throws OperationDefinitionException {
        try {
            if (this.operationKeyDefinition == null) {
                throw new OperationDefinitionException("Cannot define operation! Operation key definition is null! System: " + this.getName());
            }
            String key = KeyHelper.defineKey(this.operationKeyDefinition, context, this);
            if (Strings.isNullOrEmpty((String)key)) {
                throw new OperationDefinitionException(String.format("Cannot define operation! Key defined by definition %s in empty! System: %s", this.operationKeyDefinition, this.getName()));
            }
            Operation operation = (Operation)CoreObjectManager.getInstance().getSpecialManager(System.class, NativeManager.class).getChildByClass(this, Operation.class, key);
            if (!Objects.isNull(operation)) {
                return operation;
            }
            throw new OperationDefinitionException(String.format("No operation definition found for key [%s]", key));
        }
        catch (Exception e) {
            throw new OperationDefinitionException("Cannot process operation definition", e);
        }
    }

    @Override
    @ProduceNewObject
    public Object getNaturalId() {
        return super.getNaturalId();
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
        for (TransportConfiguration transport : this.getTransports()) {
            transport.performPostImportActions(projectId, sessionId);
        }
        for (SystemTemplate template : this.getSystemTemplates()) {
            template.performPostImportActions(projectId, sessionId);
        }
        for (Operation operation : this.getOperations()) {
            operation.performPostImportActions(projectId, sessionId);
        }
        for (SystemParsingRule parsingRule : this.getSystemParsingRules()) {
            parsingRule.performPostImportActions(projectId, sessionId);
        }
    }

    @Override
    public void unbindEntityWithHierarchy() {
        this.setEciParameters(null, null);
        this.setEcLabel(null);
        for (TransportConfiguration transportConfiguration : this.getTransports()) {
            transportConfiguration.unbindEntityWithHierarchy();
        }
    }

    @Override
    public void upStorableVersion() {
        super.upStorableVersion();
        for (TransportConfiguration transport : this.getTransports()) {
            transport.upStorableVersion();
        }
        for (SystemTemplate template : this.getSystemTemplates()) {
            template.upStorableVersion();
        }
        for (Operation operation : this.getOperations()) {
            operation.upStorableVersion();
        }
        for (SystemParsingRule parsingRule : this.getSystemParsingRules()) {
            parsingRule.upStorableVersion();
        }
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.getTransports().forEach(transport -> transport.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        this.getSystemTemplates().forEach(template -> template.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        this.getOperations().forEach(operation -> operation.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
        this.getSystemParsingRules().forEach(parsingRule -> parsingRule.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId));
    }

    public Set<TransportConfiguration> getTransports() {
        return this.transports;
    }

    public Set<SystemParsingRule> getSystemParsingRules() {
        return this.systemParsingRules;
    }

    @Override
    public String getOutgoingContextKeyDefinition() {
        return this.outgoingContextKeyDefinition;
    }

    @Override
    public String getIncomingContextKeyDefinition() {
        return this.incomingContextKeyDefinition;
    }

    public String getOperationKeyDefinition() {
        return this.operationKeyDefinition;
    }

    public Set<Operation> getOperations() {
        return this.operations;
    }

    public Set<SystemTemplate> getSystemTemplates() {
        return this.systemTemplates;
    }

    public SystemMode getMode() {
        return this.mode;
    }

    @Override
    public BigInteger getProjectId() {
        return this.projectId;
    }

    public void setTransports(Set<TransportConfiguration> transports) {
        this.transports = transports;
    }

    public void setSystemParsingRules(Set<SystemParsingRule> systemParsingRules) {
        this.systemParsingRules = systemParsingRules;
    }

    @Override
    public void setOutgoingContextKeyDefinition(String outgoingContextKeyDefinition) {
        this.outgoingContextKeyDefinition = outgoingContextKeyDefinition;
    }

    @Override
    public void setIncomingContextKeyDefinition(String incomingContextKeyDefinition) {
        this.incomingContextKeyDefinition = incomingContextKeyDefinition;
    }

    public void setOperationKeyDefinition(String operationKeyDefinition) {
        this.operationKeyDefinition = operationKeyDefinition;
    }

    public void setOperations(Set<Operation> operations) {
        this.operations = operations;
    }

    public void setSystemTemplates(Set<SystemTemplate> systemTemplates) {
        this.systemTemplates = systemTemplates;
    }

    public void setMode(SystemMode mode) {
        this.mode = mode;
    }

    @Override
    public void setProjectId(BigInteger projectId) {
        this.projectId = projectId;
    }
}

