/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.system.stub;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Strings;
import java.math.BigInteger;
import javax.persistence.Entity;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTriggerImpl;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.ei.deserialize.SituationDeserializer;
import org.qubership.automation.itf.core.util.ei.serialize.IdSerializer;

@Entity
@UserName(value="Situation start/finish event trigger")
@JsonIgnoreProperties(ignoreUnknown=true, value={"hibernateLazyInitializer", "handler"})
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=SituationEventTrigger.class)
public class SituationEventTrigger
extends EventTriggerImpl {
    private static final long serialVersionUID = 20240812L;
    public static final String TYPE = "Situation Event Trigger";
    private Situation situation;
    private On on;

    public SituationEventTrigger(Situation situationTrigger, On on) {
        super(TYPE);
        this.situation = situationTrigger;
        this.setOn(on);
    }

    public SituationEventTrigger() {
        super(TYPE);
    }

    public SituationEventTrigger(Situation parent) {
        super(TYPE);
        this.setParent(parent);
        parent.getSituationEventTriggers().add(this);
    }

    @Override
    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public Situation getParent() {
        return (Situation)super.getParent();
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=Situation.class)
    public void setParent(Situation parent) {
        super.setParent(parent);
    }

    @RefCopy
    @JsonSerialize(using=IdSerializer.class)
    public Situation getSituation() {
        return this.situation;
    }

    @JsonDeserialize(using=SituationDeserializer.class)
    public void setSituation(Situation situation) {
        this.situation = situation;
    }

    public On getOn() {
        return this.on;
    }

    public void setOn(On on) {
        this.on = on;
    }

    public void setOn(String string) {
        this.setOn(On.fromString(Strings.nullToEmpty((String)string).toUpperCase()));
    }

    @Override
    @JsonIgnore
    public String getType() {
        return TYPE;
    }

    @Override
    public void performPostImportActions(BigInteger projectId, BigInteger sessionId) {
        super.performPostImportActions(projectId, sessionId);
        if (this.getSituation() != null) {
            this.getSituation().performPostImportActions(projectId, sessionId);
        }
    }

    public static enum On {
        FINISH("Finish"),
        START("Start");

        private final String name;

        private On(String name) {
            this.name = name;
        }

        public static On fromString(String string) {
            if ((string = Strings.nullToEmpty((String)string)).isEmpty()) {
                return FINISH;
            }
            return On.valueOf(string.toUpperCase());
        }

        public String toString() {
            return this.name;
        }
    }
}

