/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.jpa.transport;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.beans.Transient;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.jpa.storage.AbstractStorable;
import org.qubership.automation.itf.core.util.constants.PropertyConstants;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public abstract class Configuration
extends AbstractStorable
implements Map<String, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private Map<String, String> configuration = new HashMap<String, String>();
    private String typeName;

    public Configuration() {
    }

    public Configuration(String typeName) {
        this.typeName = typeName;
    }

    @Override
    @Transient
    public int size() {
        return this.configuration.size();
    }

    @Override
    @Transient
    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    @Override
    @Transient
    public boolean containsKey(Object key) {
        return this.configuration.containsKey(key);
    }

    @Override
    @Transient
    public boolean containsValue(Object value) {
        return this.configuration.containsValue(value);
    }

    @Override
    @Transient
    public String get(Object key) {
        return this.configuration.get(key);
    }

    @Override
    @Transient
    public String put(String key, String value) {
        return this.configuration.put(key, value);
    }

    @Override
    @Transient
    public String remove(Object key) {
        return this.configuration.remove(key);
    }

    @Override
    @Transient
    public void putAll(Map<? extends String, ? extends String> m) {
        this.configuration.putAll(m);
    }

    @Override
    @Transient
    public void clear() {
        this.configuration.clear();
    }

    @Override
    @Transient
    public Set<String> keySet() {
        return this.configuration.keySet();
    }

    @Override
    @Transient
    public Collection<String> values() {
        return this.configuration.values();
    }

    @Override
    @Transient
    public Set<Map.Entry<String, String>> entrySet() {
        return this.configuration.entrySet();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    protected void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    @Transient
    public void fillConfiguration(Map<String, String> configuration) {
        StorableUtils.fillMap(this.getConfiguration(), configuration);
    }

    @Override
    public void performActionsForImportIntoAnotherProject(Map<BigInteger, BigInteger> replacementMap, BigInteger projectId, UUID projectUuid, boolean needToUpdateProjectId, boolean needToGenerateNewId) {
        super.performActionsForImportIntoAnotherProject(replacementMap, projectId, projectUuid, needToUpdateProjectId, needToGenerateNewId);
        this.replaceProjectUuidInFilePathProperties(projectUuid);
    }

    private void replaceProjectUuidInFilePathProperties(UUID projectUuid) {
        this.replaceProjectUuidInFilePathPropertyByKey(projectUuid, "wsdlPath");
        this.replaceProjectUuidInFilePathPropertyByKey(projectUuid, "requestXSDPath");
        this.replaceProjectUuidInFilePathPropertyByKey(projectUuid, "responseXSDPath");
        this.replaceProjectUuidInFilePathPropertyByKey(projectUuid, "configPath");
    }

    private void replaceProjectUuidInFilePathPropertyByKey(UUID projectUuid, String key) {
        Matcher matcher;
        String value = this.get(key);
        if (StringUtils.isNotEmpty((CharSequence)value) && (matcher = PropertyConstants.FILE_DIRECTORY_PATTERN.matcher(value)).find()) {
            this.put(key, new StringBuilder(value).replace(matcher.start(2), matcher.end(2), projectUuid.toString()).toString());
        }
    }
}

