/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.model.testcase;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.LabeledStorable;
import org.qubership.automation.itf.core.model.dataset.DataSetList;
import org.qubership.automation.itf.core.model.dataset.IDataSet;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.testcase.TestCase;
import org.qubership.automation.itf.core.util.annotation.RefCopy;
import org.qubership.automation.itf.core.util.helper.StorableUtils;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;

public abstract class AbstractTestCase
extends LabeledStorable
implements TestCase {
    protected List<Step> steps = Lists.newLinkedList();
    @JsonIgnore
    private Set<String> compatibleDataSetLists = Sets.newHashSetWithExpectedSize((int)10);

    @Override
    @RefCopy
    public Set<DataSetList> getCompatibleDataSetLists(Object projectId) {
        Throwable throwable = null;
        ObjectManager<DataSetList> dsMan = CoreObjectManager.getInstance().getManager(DataSetList.class);
        HashSet<DataSetList> result = new HashSet<DataSetList>();
        for (String natureId : this.compatibleDataSetLists) {
            try {
                result.addAll(dsMan.getByNatureId(natureId, projectId));
            }
            catch (Throwable th) {
                throwable = th;
            }
        }
        result.removeIf(Objects::isNull);
        if (result.isEmpty() && throwable != null) {
            throw new RuntimeException(throwable.getMessage(), throwable.getCause());
        }
        return result;
    }

    @Override
    public void addCompatibleDataSetList(DataSetList compatibleDataSetList) {
        this.compatibleDataSetLists.add(Objects.toString(compatibleDataSetList.getNaturalId()));
    }

    protected void setCompatibleDataSetLists(Set<DataSetList> compatibleDataSetLists) {
        this.compatibleDataSetLists = compatibleDataSetLists.stream().map(dsList -> Objects.toString(dsList.getNaturalId())).collect(Collectors.toSet());
    }

    @Override
    public void fillCompatibleDataSetLists(Set<DataSetList> compatibleDataSetLists) {
        this.compatibleDataSetLists.clear();
        if (compatibleDataSetLists != null) {
            this.compatibleDataSetLists.addAll(compatibleDataSetLists.stream().map(dsList -> Objects.toString(dsList.getNaturalId())).collect(Collectors.toSet()));
        }
    }

    @Nonnull
    public Set<String> getCompatibleDataSetListIds() {
        return this.compatibleDataSetLists;
    }

    public void setCompatibleDataSetListIds(Set<String> naturalIds) {
        this.compatibleDataSetLists = naturalIds;
    }

    @Override
    public List<Step> getSteps() {
        return this.steps;
    }

    protected void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    @Override
    public void fillSteps(List<Step> steps) {
        StorableUtils.fillCollection(this.getSteps(), steps);
    }

    @Override
    public IDataSet findDataSetByName(String name, Object projectId) {
        for (DataSetList dataSetList : this.getCompatibleDataSetLists(projectId)) {
            IDataSet dataSet = dataSetList.getDataSet(name, projectId);
            if (dataSet == null) continue;
            return dataSet;
        }
        return null;
    }

    @Override
    public IDataSet findDataSetById(String id, Object projectId) {
        for (DataSetList dataSetList : this.getCompatibleDataSetLists(projectId)) {
            IDataSet dataSet = dataSetList.getDataSetById(id, projectId);
            if (dataSet == null) continue;
            return dataSet;
        }
        return null;
    }
}

