/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.stub.fast;

import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.qubership.automation.itf.core.model.jpa.message.template.AbstractTemplate;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.template.OutboundTemplateTransportConfiguration;
import org.qubership.automation.itf.core.stub.fast.FastResponseCondition;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.core.util.helper.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseDescription
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ResponseDescription.class);
    private static final long serialVersionUID = 20250303L;
    private String name;
    private String id;
    private String body;
    private String responseCode;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private FastResponseCondition responseCondition;
    private Boolean skipReporting;
    private Boolean disabled = false;
    private Integer priority = 0;

    public ResponseDescription(Situation storableSituation, StubEndpointConfig.TransportTypes transportType) {
        this.name = String.format("%s__%s", storableSituation.getID(), storableSituation.getName());
        this.id = storableSituation.getID().toString();
        Instant start = Instant.now();
        this.fillBodyAndHeaders(storableSituation, transportType);
        log.debug("ResponseDescription.fillBodyAndHeaders processed in {} millis", (Object)ChronoUnit.MILLIS.between(start, Instant.now()));
        start = Instant.now();
        this.responseCondition = new FastResponseCondition(storableSituation);
        this.fillPriorityAndDisabled(storableSituation);
        this.skipReporting = false;
        log.debug("ResponseDescription.responseCondition processed in {} millis", (Object)ChronoUnit.MILLIS.between(start, Instant.now()));
    }

    private void fillBodyAndHeaders(Situation storableSituation, StubEndpointConfig.TransportTypes transportType) {
        IntegrationStep step = (IntegrationStep)storableSituation.getSteps().get(0);
        if (step != null) {
            AbstractTemplate template = step.getOperationTemplate();
            if (template == null) {
                template = step.getSystemTemplate();
            }
            if (template != null) {
                this.body = template.getText();
                if (!StringUtils.isEmpty((String)storableSituation.getPreScript())) {
                    this.body = storableSituation.getPreScript().concat("\n").concat(this.body);
                }
                for (OutboundTemplateTransportConfiguration transportConfig : template.getTransportProperties()) {
                    if (!transportType.getFullTransportType().equals(transportConfig.getTypeName())) continue;
                    this.responseCode = transportConfig.get("responseCode");
                    this.fillHeaders(transportConfig.get("headers"));
                }
            }
        } else {
            log.warn("Step is not found for situation id={}", storableSituation.getID());
        }
    }

    private void fillHeaders(String headersFromConfiguration) {
        Map<String, Object> map = Reflection.toStringMap(headersFromConfiguration);
        if (map != null) {
            this.headers.putAll(map);
        }
    }

    private void fillPriorityAndDisabled(Situation storableSituation) {
        Optional trigger = storableSituation.getOperationEventTriggers().stream().findFirst();
        if (trigger.isPresent()) {
            this.priority = ((OperationEventTrigger)trigger.get()).getPriority();
            this.disabled = !((OperationEventTrigger)trigger.get()).getState().isOn();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getBody() {
        return this.body;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public FastResponseCondition getResponseCondition() {
        return this.responseCondition;
    }

    public Boolean getSkipReporting() {
        return this.skipReporting;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void setResponseCondition(FastResponseCondition responseCondition) {
        this.responseCondition = responseCondition;
    }

    public void setSkipReporting(Boolean skipReporting) {
        this.skipReporting = skipReporting;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public ResponseDescription() {
    }
}

