/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.stub.fast;

import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.stub.fast.FastConfigurationRequest;
import org.qubership.automation.itf.core.stub.fast.StubEndpointConfig;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportConfig
implements Serializable {
    private static final long serialVersionUID = 20250303L;
    private static final Logger log = LoggerFactory.getLogger(TransportConfig.class);
    private StubEndpointConfig.TransportTypes transportType;
    private List<StubEndpointConfig> endpoints;

    public TransportConfig(FastConfigurationRequest.FastTransportConfig fastTransportConfig) {
        this.transportType = fastTransportConfig.getTransportType();
        this.endpoints = new ArrayList<StubEndpointConfig>();
        HashSet processedEndpoints = new HashSet();
        Instant start = Instant.now();
        for (FastConfigurationRequest.FastSystem fastSystem : fastTransportConfig.getSystems()) {
            HashMap<String, StubEndpointConfig> operationsEndpointMap = new HashMap<String, StubEndpointConfig>();
            fastSystem.setStorableSystem(CoreObjectManager.getInstance().getManager(System.class).getById(fastSystem.getId()));
            for (FastConfigurationRequest.FastOperation fastOperation : fastSystem.getOperations()) {
                Operation storableOperation = CoreObjectManager.getInstance().getManager(Operation.class).getById(fastOperation.getId());
                if (storableOperation != null) {
                    String endPoint = storableOperation.getTransport().getConfiguration().get("endpoint");
                    if (processedEndpoints.contains(endPoint)) {
                        endPoint = "[FAST_STUB_DUPLICATED][".concat(fastSystem.getId()).concat("]").concat(endPoint);
                    }
                    if (operationsEndpointMap.containsKey(endPoint)) {
                        ((StubEndpointConfig)operationsEndpointMap.get(endPoint)).addResponses(fastOperation, storableOperation, this.transportType);
                        continue;
                    }
                    operationsEndpointMap.put(endPoint, new StubEndpointConfig(fastSystem, fastOperation, storableOperation, this.transportType, endPoint));
                    continue;
                }
                log.warn("Storable Operation id={} is not found. Operation will not be added to FastStub configuration.", (Object)fastOperation.getId());
            }
            processedEndpoints.addAll(operationsEndpointMap.keySet());
            this.endpoints.addAll(operationsEndpointMap.values());
            fastSystem.setStorableSystem(null);
        }
        log.debug("Configuration processed in {} millis", (Object)ChronoUnit.MILLIS.between(start, Instant.now()));
    }

    public StubEndpointConfig.TransportTypes getTransportType() {
        return this.transportType;
    }

    public List<StubEndpointConfig> getEndpoints() {
        return this.endpoints;
    }

    public void setTransportType(StubEndpointConfig.TransportTypes transportType) {
        this.transportType = transportType;
    }

    public void setEndpoints(List<StubEndpointConfig> endpoints) {
        this.endpoints = endpoints;
    }

    public TransportConfig() {
    }
}

