/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class AddDate
extends Directive {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter defaultDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final String LONG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS'Z'";
    private static final DateTimeFormatter longDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS'Z'").withZone(ZoneId.systemDefault());
    private static final String DAY = "d";
    private static final String HOUR = "h";
    private static final String MINUTE = "m";

    public String getName() {
        return "add_date";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        DateTimeFormatter currentFormatter = defaultDateTimeFormatter;
        String currentDate = String.valueOf(node.jjtGetChild(0).value(internalContextAdapter));
        if ((currentDate = currentDate.replace('T', ' ')).length() != 19) {
            currentFormatter = longDateTimeFormatter;
        }
        Date date = null;
        if ((date = this.getDate(currentDate, date, currentFormatter)) != null) {
            String addedTime = "";
            String dataString = "";
            for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                if (node.jjtGetChild(i) != null) {
                    addedTime = String.valueOf(node.jjtGetChild(i).value(internalContextAdapter));
                    dataString = this.addTimeToData(date, addedTime, currentFormatter);
                    date = this.getDate(dataString, date, currentFormatter);
                    continue;
                }
                this.rsvc.getLog().warn((Object)"Not added date");
            }
            dataString = dataString.replace(' ', 'T');
            this.rsvc.evaluate((Context)internalContextAdapter, writer, addedTime, dataString);
        }
        return true;
    }

    private Date getDate(String stringDate, Date date, DateTimeFormatter currentFormatter) {
        try {
            date = Date.from(Instant.from(currentFormatter.parse(stringDate)));
        }
        catch (Exception e) {
            this.rsvc.getLog().error((Object)("Error while parsing of " + stringDate + " to date (expected format is " + currentFormatter.toString() + ")"), (Throwable)e);
        }
        return date;
    }

    private String addTimeToData(Date date, String addedTime, DateTimeFormatter currentFormatter) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int timeUnit = this.determineCalendarFieldByAddedTime(addedTime);
        if (timeUnit != 0) {
            String d = addedTime.replace(this.determineTimeUnitByCalendarField(timeUnit), "");
            calendar.add(timeUnit, Integer.parseInt(d));
        }
        return currentFormatter.format(calendar.getTime().toInstant());
    }

    private int determineCalendarFieldByAddedTime(String addedTime) {
        if (addedTime.toLowerCase().contains(DAY)) {
            return 5;
        }
        if (addedTime.toLowerCase().contains(HOUR)) {
            return 10;
        }
        if (addedTime.toLowerCase().contains(MINUTE)) {
            return 12;
        }
        return 0;
    }

    private String determineTimeUnitByCalendarField(int timeUnit) {
        switch (timeUnit) {
            case 5: {
                return DAY;
            }
            case 10: {
                return HOUR;
            }
            case 12: {
                return MINUTE;
            }
        }
        return "";
    }
}

