/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class EncodeSaml
extends Directive {
    public String getName() {
        return "encode_saml";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        String encoding;
        if (node.jjtGetNumChildren() == 1) {
            encoding = "UTF-8";
        } else if (node.jjtGetNumChildren() == 2) {
            encoding = node.jjtGetChild(1) != null ? String.valueOf(node.jjtGetChild(1).value(internalContextAdapter)) : "UTF-8";
        } else {
            this.rsvc.getLog().error((Object)"Incorrect #encode_saml directive format. Check directive parameters: Parameter#1 - content, Parameter#2 (optional)- encoding name, i.e. \"UTF-8\", \"SHIFT-JIS\"");
            writer.append("#encode_saml:incorrect parameters");
            return true;
        }
        if (node.jjtGetChild(0) != null) {
            String stringValue = String.valueOf(node.jjtGetChild(0).value(internalContextAdapter));
            writer.append(this.encodeSaml(stringValue, encoding));
        }
        return true;
    }

    public String encodeSaml(String text, String encoding) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(8, true);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)os, deflater);
            deflaterOutputStream.write(text.getBytes(encoding));
            deflaterOutputStream.close();
            os.close();
            String base64 = Base64.encodeBase64String((byte[])os.toByteArray());
            return URLEncoder.encode(base64, encoding);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while #encode_saml directive processing: " + e + (e.getCause() == null ? "" : "\nCaused by: " + e.getCause().toString()));
        }
    }
}

