/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class EncodeUrl
extends Directive {
    private static final String JIS = "jis";

    public String getName() {
        return "encodeUrl";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        if (node.jjtGetNumChildren() != 2) {
            this.rsvc.getLog().error((Object)"Incorrect #encodeUrl directive format. Check directive parameters: (Parameter#1 - content, Parameter#2 - encoding name, i.e. \"UTF-8\", \"SHIFT-JIS\")");
            writer.append("#err");
            return true;
        }
        String content = String.valueOf(node.jjtGetChild(0).value(internalContextAdapter));
        String enc = String.valueOf(node.jjtGetChild(1).value(internalContextAdapter));
        writer.append(this.encodeUrl(content, enc));
        return true;
    }

    private String encodeUrl(String content, String encoding) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        try {
            if (!StringUtils.containsIgnoreCase((CharSequence)encoding.trim(), (CharSequence)JIS)) {
                return URLEncoder.encode(content, encoding);
            }
            byte[] bytes = content.getBytes(encoding);
            String s = new String(bytes, StandardCharsets.ISO_8859_1.name());
            return URLEncoder.encode(s, StandardCharsets.ISO_8859_1.name());
        }
        catch (UnsupportedEncodingException e) {
            this.rsvc.getLog().error((Object)("Unsupported encoding " + encoding + " for #encodeUrl directive"));
            return "#err";
        }
    }
}

