/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.template.velocity.directives;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;

public class ToJsonString
extends Directive {
    public String getName() {
        return "toJson";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException {
        Object obj;
        boolean prettyPrint = false;
        int count = node.jjtGetNumChildren();
        if (count < 1) {
            throw new IllegalArgumentException("Directive '#" + this.getName() + "' arguments are missed.\nThe 1st argument is $obj (to be printed as Json),\nThe 2nd (optional) argument is true/false; if true, json is pretty-printed.");
        }
        if (count >= 2) {
            Object prettyPrintParameter = node.jjtGetChild(1).value(internalContextAdapter);
            prettyPrint = prettyPrintParameter instanceof Boolean ? (Boolean)prettyPrintParameter : Boolean.parseBoolean(prettyPrintParameter.toString());
        }
        if ((obj = node.jjtGetChild(0).value(internalContextAdapter)) == null) {
            return true;
        }
        if (obj instanceof JsonContext) {
            writer.append(((JsonContext)obj).getJsonString());
        } else if (obj instanceof Map || obj instanceof List) {
            ObjectMapper mapper = new ObjectMapper();
            if (prettyPrint) {
                mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            }
            writer.append(mapper.writeValueAsString(obj));
        } else {
            writer.append(obj.toString());
        }
        return true;
    }
}

