/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.config;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.qubership.automation.itf.core.util.config.AbstractConfig;

public class Config
extends AbstractConfig {
    protected static final String RUNNING_URL = "runningUrl";
    protected static final String RUNNING_HOSTNAME = "runningHostname";
    protected static final String RUNNING_PORT = "runningPort";
    protected static final String CONTEXT_POPUP_URL = "contextPopupUrl";
    protected static final List<MutablePair<Integer, Integer>> validCodeRanges = new ArrayList<MutablePair<Integer, Integer>>();
    private static final String CONFIG_FILENAME = "application.properties";
    private static volatile Config config;

    private Config(boolean withLoading) {
        super(withLoading, CONFIG_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getConfig() {
        if (config != null) return config;
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (config != null) return config;
            config = new Config(true);
            Config.addDefaultHostProperties();
            Config.parseResponseCodes();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    public static String getConfigFilename() {
        return CONFIG_FILENAME;
    }

    public static List<MutablePair<Integer, Integer>> parseCodeRanges(String strCodes) {
        String[] list;
        ArrayList<MutablePair<Integer, Integer>> rangesList = new ArrayList<MutablePair<Integer, Integer>>();
        for (String item : list = strCodes.split("[,;]")) {
            MutablePair<Integer, Integer> boundaries;
            if (StringUtils.isBlank((CharSequence)item) || (boundaries = Config.parseCodeRange(item.split("-"))) == null) continue;
            rangesList.add(boundaries);
        }
        return rangesList;
    }

    private static void parseResponseCodes() {
        String strCodes = config.getString("http.response.code.success");
        if (StringUtils.isBlank((CharSequence)strCodes)) {
            return;
        }
        validCodeRanges.addAll(Config.parseCodeRanges(strCodes));
    }

    private static MutablePair<Integer, Integer> parseCodeRange(String[] range) {
        MutablePair boundaries = new MutablePair();
        if (range == null || range.length < 1 || range.length > 2) {
            return null;
        }
        for (int i = 0; i < range.length; ++i) {
            try {
                int val = Integer.parseInt(range[i].trim());
                if (val <= 0) continue;
                if (i == 0) {
                    boundaries.setLeft((Object)val);
                    if (range.length != 1) continue;
                    boundaries.setRight((Object)val);
                    continue;
                }
                boundaries.setRight((Object)val);
                continue;
            }
            catch (NumberFormatException goaway) {
                LOGGER.error("Response codes range: Invalid range boundary[{}]: {}", (Object)i, (Object)range[i]);
                return null;
            }
        }
        if ((Integer)boundaries.getLeft() > (Integer)boundaries.getRight()) {
            LOGGER.error("Response codes range: Left boundary is greater than right: {} and {}", boundaries.getLeft(), boundaries.getRight());
            return null;
        }
        return boundaries;
    }

    private static void addDefaultHostProperties() {
        String url;
        if (StringUtils.isBlank((CharSequence)config.getRunningHostname())) {
            config.addProperty(RUNNING_HOSTNAME, Config.determineHostname());
        }
        if (StringUtils.isBlank((CharSequence)config.getRunningPort())) {
            config.addProperty(RUNNING_PORT, Config.determinePort());
        }
        if (StringUtils.isBlank((CharSequence)(url = config.getString(RUNNING_URL)))) {
            config.addProperty(RUNNING_URL, Config.constructRunningUrl());
        } else if (!(url = url.trim()).endsWith("/")) {
            config.addProperty(RUNNING_URL, url + "/");
        }
        config.addProperty(CONTEXT_POPUP_URL, config.getString(RUNNING_URL) + "#/context/");
    }

    private static String constructRunningUrl() {
        return String.format("%s://%s:%s/", "http", config.getRunningHostname(), config.getRunningPort());
    }

    private static String determineHostname() {
        try {
            return Inet4Address.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Can't determine hostname of ITF running machine!", e);
        }
    }

    private static String determinePort() {
        return System.getProperties().containsKey("port") ? System.getProperties().getProperty("port") : "8080";
    }

    public List<MutablePair<Integer, Integer>> getValidCodeRanges() {
        return validCodeRanges;
    }

    public String getString(String key) {
        String result = this.getKeyValue(key, String.class, this.properties);
        return StringUtils.isNotEmpty((CharSequence)result) ? result.trim() : null;
    }

    public String getStringOrDefault(String key, String defaultValue) {
        String result = this.getKeyValue(key, String.class, this.properties);
        return StringUtils.isNotEmpty((CharSequence)result) ? result.trim() : defaultValue;
    }

    public Integer getInt(String key) {
        String keyValue = this.getKeyValue(key, String.class, this.properties);
        return StringUtils.isNotEmpty((CharSequence)keyValue) ? Integer.valueOf(Integer.parseInt(keyValue)) : null;
    }

    public Integer getIntOrDefault(String key, int defaultValue) {
        String keyValue = this.getKeyValue(key, String.class, this.properties);
        return StringUtils.isNotEmpty((CharSequence)keyValue) ? Integer.parseInt(keyValue) : defaultValue;
    }

    private <T> T getKeyValue(String key, Class<T> type, Map container) {
        Object value = container.get(key);
        if (value == null) {
            LOGGER.debug("Key '{}' not found in properties cache", (Object)key);
            return null;
        }
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            LOGGER.error("Type mismatch: actual type '{}', expected '{}'. Key is '{}', value is '{}'", new Object[]{value.getClass().getSimpleName(), type.getSimpleName(), key, value});
            return null;
        }
    }

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void merge(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public Config getByPrefix(String prefix, boolean truncPrefix) {
        Config config = new Config(false);
        for (Map.Entry<Object, Object> property : this.properties.entrySet()) {
            String key = property.getKey().toString();
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) continue;
            config.addProperty(truncPrefix ? key.substring(prefix.length() + 1) : key, property.getValue());
        }
        return config;
    }

    public Config getByPrefix(String prefix) {
        return this.getByPrefix(prefix, true);
    }

    public Collection<Object> getValues() {
        return this.getValues(Object.class);
    }

    public <T> Collection<T> getValues(Class<T> type) {
        Collection<Object> objects = this.properties.values();
        LinkedList<T> list = new LinkedList<T>();
        for (Object object : objects) {
            list.addFirst(type.cast(object));
        }
        return list;
    }

    public String getRunningHostname() {
        return config.getString(RUNNING_HOSTNAME);
    }

    public String getRunningPort() {
        return config.getString(RUNNING_PORT);
    }

    public String getContextPopupUrl() {
        return config.getString(CONTEXT_POPUP_URL);
    }

    public String getRunningUrl() {
        String url = config.getString(RUNNING_URL);
        return StringUtils.isNotBlank((CharSequence)url) ? url : Config.constructRunningUrl();
    }
}

