/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.constants;

import com.google.common.base.Strings;

public enum Mep {
    OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS("outbound-request/response-synchronous", true, true, false, false),
    OUTBOUND_REQUEST_ASYNCHRONOUS("outbound-request-asynchronous", true, true, true, true),
    OUTBOUND_RESPONSE_ASYNCHRONOUS("outbound-response-asynchronous", true, false, true, true),
    INBOUND_REQUEST_RESPONSE_SYNCHRONOUS("inbound-request/response-synchronous", false, true, false, false),
    INBOUND_REQUEST_SYNCHRONOUS("inbound-request-synchronous", false, true, false, true),
    INBOUND_RESPONSE_SYNCHRONOUS("inbound-response-synchronous", false, false, false, true),
    INBOUND_REQUEST_ASYNCHRONOUS("inbound-request-asynchronous", false, true, true, true),
    INBOUND_RESPONSE_ASYNCHRONOUS("inbound-response-asynchronous", false, false, true, true);

    private final String string;
    private final boolean async;
    private final boolean outbound;
    private final boolean request;
    private final boolean oneDirection;

    private Mep(String string2, boolean outbound, boolean request, boolean async, boolean oneDirection) {
        this.string = string2;
        this.async = async;
        this.outbound = outbound;
        this.request = request;
        this.oneDirection = oneDirection;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isSync() {
        return !this.async;
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public boolean isInbound() {
        return !this.outbound;
    }

    public boolean isRequest() {
        return this.request;
    }

    public boolean isResponse() {
        return !this.oneDirection || !this.request;
    }

    public boolean isOneDirection() {
        return this.oneDirection;
    }

    public boolean isBothDirection() {
        return !this.oneDirection;
    }

    public boolean isInboundRequest() {
        return !this.outbound && this.request;
    }

    public boolean isOutboundRequest() {
        return this.outbound && this.request;
    }

    public String toString() {
        return this.string;
    }

    public static Mep fromString(String string) {
        for (Mep mep : Mep.values()) {
            if (!mep.name().equals(Strings.nullToEmpty((String)string).toUpperCase()) && !mep.string.equalsIgnoreCase(string)) continue;
            return mep;
        }
        return null;
    }
}

