/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.constants;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TriggerState {
    ACTIVE("Active", true),
    INACTIVE("Inactive", false),
    ERROR("Error", false),
    STARTING("Starting", true),
    SHUTTING_DOWN("Shutting down", false),
    ACTIVE_PART("Active (Not all)", true),
    ACTIVE_ERROR("Active (Errors)", true),
    EMPTY("Empty", false);

    private String state;
    private boolean isOn;

    private TriggerState(String state, boolean isOn) {
        this.state = state;
        this.isOn = isOn;
    }

    public String toString() {
        return this.state;
    }

    @JsonValue
    public String getState() {
        return this.state;
    }

    public boolean isOn() {
        return this.isOn;
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static TriggerState fromString(@JsonProperty(value="triggerState") String state) {
        for (TriggerState triggerState : TriggerState.values()) {
            if (triggerState.state.equalsIgnoreCase(state)) {
                return triggerState;
            }
            if (!triggerState.name().equalsIgnoreCase(state)) continue;
            return triggerState;
        }
        return null;
    }
}

