/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.descriptor;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.qubership.automation.itf.core.util.annotation.DefaultValue;
import org.qubership.automation.itf.core.util.annotation.Options;
import org.qubership.automation.itf.core.util.annotation.Parameter;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.helper.Reflection;
import org.qubership.automation.itf.core.util.provider.PropertyProvider;

public class Extractor {
    private Extractor() {
    }

    public static List<PropertyDescriptor> extractProperties(PropertyProvider object) {
        Set<Field> fieldSet = Extractor.getFields(object.getClass());
        Extractor.appendWithParentFields(fieldSet, object.getClass().getSuperclass());
        ArrayList properties = Lists.newArrayListWithCapacity((int)fieldSet.size());
        fieldSet.forEach(field -> {
            Parameter parameter = field.getAnnotation(Parameter.class);
            Options options = field.getAnnotation(Options.class);
            PropertyDescriptor descriptor = new PropertyDescriptor(parameter.shortName(), parameter.longName(), field.getType().getName(), parameter.description(), parameter.optional(), parameter.forTemplate(), parameter.fromServer(), parameter.forServer(), parameter.forTrigger(), options != null, options != null ? options.value() : null, parameter.isDynamic(), parameter.isRedefined(), parameter.loadTemplate(), parameter.userSettings(), parameter.order(), parameter.fileDirectoryType(), parameter.uiCategory(), parameter.validatePattern());
            DefaultValue defaultValue = field.getAnnotation(DefaultValue.class);
            if (defaultValue != null) {
                descriptor.setDefaultValue(defaultValue.value());
            }
            properties.add(descriptor);
        });
        return properties;
    }

    public static List<String> extractMandatory(List<PropertyDescriptor> properties) {
        ArrayList mandatoryProperties = Lists.newArrayListWithCapacity((int)properties.size());
        properties.forEach(prop -> {
            if (!prop.isOptional()) {
                mandatoryProperties.add(prop.getShortName());
            }
        });
        return mandatoryProperties;
    }

    public static String checkMandatoryProperties(List<String> mandatoryProperties, Map<String, Object> properties) {
        StringBuilder error = new StringBuilder();
        if (!mandatoryProperties.isEmpty() && !properties.isEmpty()) {
            for (String propname : mandatoryProperties) {
                if (properties.containsKey(propname)) {
                    Object val = properties.get(propname);
                    if (val != null && !val.toString().isEmpty()) continue;
                    error.append("Mandatory property '").append(propname).append("' value is empty. ");
                    continue;
                }
                error.append("Mandatory property '").append(propname).append("' is missed. ");
            }
        }
        return error.toString();
    }

    private static void appendWithParentFields(Set<Field> fieldSet, Class<?> superclass) {
        for (Class<?> parentClass = superclass; parentClass != null && PropertyProvider.class.isAssignableFrom(parentClass); parentClass = parentClass.getSuperclass()) {
            Reflection.getFieldsAnnotatedBy(parentClass, Parameter.class).forEach(field -> {
                if (!fieldSet.contains(field)) {
                    fieldSet.add((Field)field);
                }
            });
        }
    }

    private static Set<Field> getFields(Class<?> clazz) {
        return Reflection.getFieldsAnnotatedBy(clazz, Parameter.class).parallelStream().collect(Collectors.toSet());
    }
}

