/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.descriptor;

import java.io.Serializable;
import org.qubership.automation.itf.core.util.helper.Reflection;

public class PropertyDescriptor
implements Serializable {
    private static final long serialVersionUID = -1115137482811099873L;
    private final boolean loadTemplate;
    private boolean userSettings;
    private final String shortName;
    private final String longName;
    private final String typeName;
    private final boolean optional;
    private final boolean fromServer;
    private final boolean forServer;
    private final boolean forTemplate;
    private final boolean forTrigger;
    private final boolean select;
    private final String[] options;
    private final String description;
    private final boolean dynamic;
    private final boolean redefined;
    private final int order;
    private final boolean map;
    private Object defaultValue;
    private final String fileDirectoryType;
    private final String uiCategory;
    private final String validatePattern;

    public PropertyDescriptor(String shortName, String longName, String typeName, String description, boolean optional, boolean forTemplate, boolean fromServer, boolean forServer, boolean forTrigger, boolean select, String[] options, boolean dynamic, boolean redefined, boolean loadTemplate, boolean userSettings, int order, String fileDirectoryType, String uiCategory, String validatePattern) {
        this.shortName = shortName;
        this.longName = longName;
        this.typeName = typeName;
        this.optional = optional;
        this.forTemplate = forTemplate;
        this.description = description;
        this.fromServer = fromServer;
        this.forServer = forServer;
        this.forTrigger = forTrigger;
        this.select = select;
        this.options = options;
        this.dynamic = dynamic;
        this.redefined = redefined;
        this.loadTemplate = loadTemplate;
        this.userSettings = userSettings;
        this.order = order;
        this.map = typeName.equals("java.util.Map");
        this.fileDirectoryType = fileDirectoryType;
        this.uiCategory = uiCategory;
        this.validatePattern = validatePattern;
    }

    public String getDescription() {
        return this.description;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isForTemplate() {
        return this.forTemplate;
    }

    public boolean isFromServer() {
        return this.fromServer;
    }

    public boolean isForServer() {
        return this.forServer;
    }

    public boolean isForTrigger() {
        return this.forTrigger;
    }

    public Object convert(String value) {
        try {
            return Reflection.detectAndConvertFromString(Class.forName("java.io.File".equals(this.typeName) ? "java.lang.String" : this.typeName), value);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot convert string value", e);
        }
    }

    public boolean isSelect() {
        return this.select;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public String[] getOptions() {
        return this.options;
    }

    public boolean isRedefined() {
        return this.redefined;
    }

    public boolean loadTemplate() {
        return this.loadTemplate;
    }

    public boolean userSettings() {
        return this.userSettings;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isMap() {
        return this.map;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getFileDirectoryType() {
        return this.fileDirectoryType;
    }

    public String getUiCategory() {
        return this.uiCategory;
    }

    public String getValidatePattern() {
        return this.validatePattern;
    }
}

