/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.eds.repository;

import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.qubership.automation.itf.core.util.eds.configuration.ItfGridFsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsCriteria;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.stereotype.Repository;

@Repository(value="ItfGridFsRepository")
@ConditionalOnBean(value={ItfGridFsConfiguration.class})
public class ItfGridFsRepository {
    private final GridFsTemplate gridFsTemplate;

    @Autowired
    public ItfGridFsRepository(GridFsTemplate gridFsTemplate) {
        this.gridFsTemplate = gridFsTemplate;
    }

    public GridFSFindIterable findByMetadata(Map<String, Object> metadataParams) {
        return this.gridFsTemplate.find(this.createQuery(metadataParams));
    }

    public GridFSFile findById(ObjectId objectId) {
        return this.gridFsTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)objectId)));
    }

    public ObjectId store(Map<String, Object> metadataParams, String fileName, InputStream fileInputStream) {
        return this.gridFsTemplate.store(fileInputStream, fileName, this.createDocument(metadataParams));
    }

    public void delete(Map<String, Object> metadataParams, String fileName) {
        GridFSFindIterable gridFsFiles = this.gridFsTemplate.find(this.createQuery(metadataParams).addCriteria((CriteriaDefinition)GridFsCriteria.whereFilename().is((Object)fileName)));
        for (GridFSFile gridFsFile : gridFsFiles) {
            this.gridFsTemplate.delete(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)gridFsFile.getObjectId())));
        }
    }

    public GridFsResource getResource(GridFSFile gridFsFile) {
        return this.gridFsTemplate.getResource(gridFsFile);
    }

    private Document createDocument(Map<String, Object> metadata) {
        Document document = new Document();
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            document.append(entry.getKey(), entry.getValue());
        }
        return document;
    }

    private Query createQuery(Map<String, Object> metadataParams) {
        Iterator<Map.Entry<String, Object>> entryIterator = metadataParams.entrySet().iterator();
        Map.Entry<String, Object> firstEntry = entryIterator.next();
        Criteria criteria = Criteria.where((String)("metadata." + firstEntry.getKey())).is(firstEntry.getValue());
        while (entryIterator.hasNext()) {
            Map.Entry<String, Object> entry = entryIterator.next();
            criteria.and("metadata." + entry.getKey()).is(entry.getValue());
        }
        return new Query((CriteriaDefinition)criteria);
    }
}

