/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.eds.service;

import java.util.HashMap;

public enum EdsContentType {
    WSDL_XSD("wsdl-xsd"),
    DIAMETER_DICTIONARY("diameter-dictionary"),
    DATASET("dataset"),
    KEYSTORE("keystore"),
    FAST_STUB("fast-stub");

    private final String value;
    private static final HashMap<String, String> predefinedPathMap;
    private static final HashMap<String, String> predefinedFileNameMap;

    private EdsContentType(String value) {
        this.value = value;
    }

    public String getStringValue() {
        return this.value;
    }

    public static EdsContentType fromValue(String value) {
        for (EdsContentType contentType : EdsContentType.values()) {
            if (!contentType.getStringValue().equals(value)) continue;
            return contentType;
        }
        throw new IllegalArgumentException("Unexpected eds contentType value '" + value + "'.");
    }

    public static String getPredefinedPathByType(String type) {
        return predefinedPathMap.get(type);
    }

    public static String getPredefinedFileNameByType(String type) {
        return predefinedFileNameMap.get(type);
    }

    static {
        predefinedPathMap = new HashMap();
        predefinedFileNameMap = new HashMap();
        predefinedPathMap.put(KEYSTORE.getStringValue(), "");
        predefinedPathMap.put(FAST_STUB.getStringValue(), "");
        predefinedFileNameMap.put(FAST_STUB.getStringValue(), "fast_stub_config.json");
    }
}

