/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.eds.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.UUID;
import org.qubership.automation.itf.core.util.eds.model.FileInfo;
import org.qubership.automation.itf.core.util.eds.service.EdsContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileManagementService {
    private static final Logger log = LoggerFactory.getLogger(FileManagementService.class);
    @Value(value="${local.storage.directory:data}")
    private String rootFolder;

    public void save(Collection<FileInfo> filesInfo) {
        for (FileInfo fileInfo : filesInfo) {
            this.save(fileInfo);
        }
    }

    public File save(FileInfo fileInfo) {
        return this.save(fileInfo.getContentType(), fileInfo.getProjectUuid(), fileInfo.getFilePath(), fileInfo.getFileName(), fileInfo.getInputStream());
    }

    public File save(String contentType, UUID projectUuid, String filePath, String fileName, InputStream inputStream) {
        String directoryName = this.getDirectory(contentType, projectUuid, filePath);
        try {
            File targetFile = this.findOrCreateDirectoryWithFile(directoryName, fileName);
            Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return targetFile;
        }
        catch (Exception exc) {
            log.error("Error while saving file '{}' to local directory: {}", new Object[]{fileName, directoryName, exc});
            return null;
        }
    }

    public void delete(FileInfo fileInfo) {
        Path path = this.getDirectoryPath(fileInfo.getContentType(), fileInfo.getProjectUuid(), fileInfo.getFilePath()).resolve(fileInfo.getFileName());
        try {
            Files.delete(path);
            log.info("File by path '{}' is deleted from storage successfully.", (Object)path);
        }
        catch (IOException e) {
            log.error("An error occurred while deleting file by path '{}'.", (Object)path, (Object)e);
        }
    }

    public boolean isContentTypeExist(String contentType) {
        for (EdsContentType value : EdsContentType.values()) {
            if (!contentType.equals(value.getStringValue())) continue;
            return true;
        }
        return false;
    }

    private File findOrCreateDirectoryWithFile(String directoryName, String fileName) {
        File directory = new File(directoryName);
        if (!directory.exists() && !directory.mkdirs()) {
            log.info("Directory {} is created", (Object)directoryName);
        }
        return new File(directoryName + "/" + fileName);
    }

    public String getDirectory(String contentType, UUID projectUuid, String filePath) {
        return this.dontUseProjectForCreatingDirectory(contentType) ? this.rootFolder + "/" + contentType + filePath : this.rootFolder + "/" + contentType + "/" + projectUuid + filePath;
    }

    public Path getDirectoryPath(String contentType, UUID projectUuid, String filePath) {
        if (EdsContentType.KEYSTORE.getStringValue().equals(contentType)) {
            return Paths.get(this.rootFolder, contentType, filePath);
        }
        return Paths.get(this.rootFolder, contentType, projectUuid.toString(), filePath);
    }

    public boolean dontUseProjectForCreatingDirectory(String contentType) {
        return EdsContentType.KEYSTORE.getStringValue().equals(contentType);
    }

    public String calcPredefinedPath(String contentType, String path) {
        return EdsContentType.getPredefinedPathByType(contentType) == null ? path : EdsContentType.getPredefinedPathByType(contentType);
    }

    public String calcPredefinedFileName(String contentType, String fileName) {
        return EdsContentType.getPredefinedFileNameByType(contentType) == null ? fileName : EdsContentType.getPredefinedFileNameByType(contentType);
    }
}

