/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.ei.deserialize;

import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Map;
import org.qubership.automation.itf.core.util.ei.deserialize.ImportedDataCache;

public class DeserializedEntitiesCache {
    private static volatile DeserializedEntitiesCache deserializedEntitiesCache;
    private Map<BigInteger, ImportedDataCache> sessionToStorable = Maps.newHashMap();

    private DeserializedEntitiesCache() {
        if (deserializedEntitiesCache != null) {
            throw new RuntimeException("Use getInstance() method to get the single instance of this class.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeserializedEntitiesCache getInstance() {
        if (deserializedEntitiesCache != null) return deserializedEntitiesCache;
        Class<DeserializedEntitiesCache> clazz = DeserializedEntitiesCache.class;
        synchronized (DeserializedEntitiesCache.class) {
            if (deserializedEntitiesCache != null) return deserializedEntitiesCache;
            deserializedEntitiesCache = new DeserializedEntitiesCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return deserializedEntitiesCache;
        }
    }

    public ImportedDataCache getCacheBySessionId(BigInteger sessionId) {
        return this.sessionToStorable.get(sessionId);
    }

    public ImportedDataCache createSessionRecord(BigInteger sessionId, BigInteger projectId) {
        ImportedDataCache importedDataCache = new ImportedDataCache();
        importedDataCache.setProjectId(projectId);
        this.sessionToStorable.put(sessionId, importedDataCache);
        return importedDataCache;
    }
}

