/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.ei.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FolderDeserializer<T extends Folder>
extends JsonDeserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(FolderDeserializer.class);
    private Class<T> folderClass;

    public FolderDeserializer(Class<T> folderClass) {
        this.folderClass = folderClass;
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        try {
            Folder folder = (Folder)this.folderClass.newInstance();
            folder.setID(jsonParser.getBigIntegerValue());
            return (T)folder;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Unknown type of folder: " + this.folderClass.getName());
            throw new IllegalArgumentException(e);
        }
    }
}

