/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.ei.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.qubership.automation.itf.core.model.jpa.server.ServerHB;
import org.qubership.automation.itf.core.model.jpa.system.System;

public class SystemServerMapDeserializer
extends JsonDeserializer<Map<System, ServerHB>> {
    public Map<System, ServerHB> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new HashMap<System, ServerHB>());
    }

    public Map<System, ServerHB> deserialize(JsonParser p, DeserializationContext ctxt, Map<System, ServerHB> intoValue) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        ObjectMapper mapper = new ObjectMapper();
        Iterator nodeFields = node.fields();
        while (nodeFields.hasNext()) {
            Map.Entry next = (Map.Entry)nodeFields.next();
            JsonNode keyNode = mapper.readTree((String)next.getKey());
            JsonNode valueNode = (JsonNode)next.getValue();
            intoValue.put(this.createSimpleSystem(new BigInteger(keyNode.toString())), this.createSimpleServer(new BigInteger(valueNode.toString())));
        }
        return intoValue;
    }

    private System createSimpleSystem(BigInteger id) {
        System system = new System();
        system.setID(id);
        return system;
    }

    private ServerHB createSimpleServer(BigInteger id) {
        ServerHB server = new ServerHB();
        server.setID(id);
        return server;
    }
}

