/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.exception;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.automation.itf.core.util.exception.CoreException;

public class Exceptions {
    private static final Function<Throwable, String> TO_MESSAGE = new Function<Throwable, String>(){

        @Nonnull
        public String apply(@Nullable Throwable input) {
            return ExceptionUtils.getMessage((Throwable)input);
        }
    };

    public static String getMessagesOnly(Throwable throwable) {
        return Joiner.on((String)":\n").join((Iterable)Lists.transform((List)ExceptionUtils.getThrowableList((Throwable)throwable), TO_MESSAGE));
    }

    public static void fillWithBriefInfo(@Nonnull StringBuilder sb, @Nonnull Throwable throwable) {
        List throwableList = ExceptionUtils.getThrowableList((Throwable)throwable);
        List<String> extractedRootCause = null;
        if (!(throwable instanceof CoreException)) {
            extractedRootCause = Exceptions.extractRootCause(throwableList);
        }
        Joiner.on((String)":\n").appendTo(sb, (Iterable)Lists.transform((List)throwableList, TO_MESSAGE));
        if (extractedRootCause != null) {
            for (String causeStr : extractedRootCause) {
                sb.append("\n").append(causeStr);
            }
        }
    }

    @Nullable
    private static List<String> extractRootCause(@Nonnull List<Throwable> list) {
        if (list.isEmpty()) {
            return null;
        }
        Throwable rootCause = list.get(list.size() - 1);
        String[] causeStrs = ExceptionUtils.getRootCauseStackTrace((Throwable)rootCause);
        list.remove(rootCause);
        return Arrays.asList(causeStrs);
    }
}

