/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.generator.id;

import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.util.generator.id.IdGeneratorInterface;

public class BinaryIdGenerator
implements IdGeneratorInterface {
    private String data;

    public BinaryIdGenerator(String value) {
        this.data = value;
    }

    @Inject
    public BinaryIdGenerator() {
        this.data = "data" + Math.random() * (double)System.currentTimeMillis() / 31.0;
    }

    @Override
    public Object getId(Class<? extends Storable> clazz) {
        return this.getBinary();
    }

    @Override
    public void setStartFrom(Object id, Class<? extends Storable> clazz) {
    }

    private String getBinary() {
        byte[] bytes = this.data.getBytes(StandardCharsets.UTF_8);
        StringBuilder binary = new StringBuilder();
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int b;
            int val = b = byArray[i];
            for (int i2 = 0; i2 < 8; ++i2) {
                binary.append((val & 0x80) == 0 ? 0 : 1);
                val <<= 1;
            }
        }
        return binary.toString();
    }
}

