/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.generator.id;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.concurrent.LinkedBlockingQueue;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.qubership.automation.itf.core.util.generator.tools.InternalDataBaseSqlExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UniqueIdGenerator
implements IdentifierGenerator {
    private static final Logger log = LoggerFactory.getLogger(UniqueIdGenerator.class);
    private static final LinkedBlockingQueue<BigInteger> IDS = new LinkedBlockingQueue();
    private static final LinkedBlockingQueue<BigInteger> IDS_REPORTING = new LinkedBlockingQueue();
    public static InternalDataBaseSqlExecutor INTERNAL_DATABASE_SQL_EXECUTOR;

    public UniqueIdGenerator() {
    }

    @Autowired
    public UniqueIdGenerator(InternalDataBaseSqlExecutor internalDataBaseSqlExecutor) {
        INTERNAL_DATABASE_SQL_EXECUTOR = internalDataBaseSqlExecutor;
    }

    public static Serializable generate() {
        return UniqueIdGenerator.getNextIdFromQueue();
    }

    public Serializable generate(SharedSessionContractImplementor sharedSessionContractImplementor, Object o) throws HibernateException {
        return UniqueIdGenerator.getNextIdFromQueue();
    }

    public static Serializable generateReportingId() {
        return UniqueIdGenerator.getNextReportingIdFromQueue();
    }

    private static synchronized Serializable getNextIdFromQueue() {
        if (IDS.isEmpty()) {
            try {
                IDS.addAll(INTERNAL_DATABASE_SQL_EXECUTOR.selectArrayViaNonParameterizedFunction(true));
            }
            catch (SQLException e) {
                log.error("Error while generating the next id: " + e);
                throw new HibernateException((Throwable)e);
            }
        }
        return IDS.poll();
    }

    private static synchronized Serializable getNextReportingIdFromQueue() {
        if (IDS_REPORTING.isEmpty()) {
            try {
                IDS_REPORTING.addAll(INTERNAL_DATABASE_SQL_EXECUTOR.selectArrayViaNonParameterizedFunction(false));
            }
            catch (SQLException e) {
                log.error("Error while generating the next reporting id: " + e);
                throw new HibernateException((Throwable)e);
            }
        }
        return IDS_REPORTING.poll();
    }
}

