/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.generator.prefix;

import com.google.common.collect.Maps;
import java.util.Map;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.dataset.DataSetList;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.environment.TriggerConfiguration;
import org.qubership.automation.itf.core.model.jpa.folder.Folder;
import org.qubership.automation.itf.core.model.jpa.message.parser.OperationParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.parser.SystemParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.report.LinkCollectorConfiguration;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.generator.prefix.IPrefixFactory;

public class StringPrefixFactory
implements IPrefixFactory {
    private final Map<Class<? extends Storable>, String> prefixStorage = Maps.newLinkedHashMap();

    public StringPrefixFactory() {
        this.prefixStorage.put(System.class, "SY_");
        this.prefixStorage.put(Situation.class, "SI_");
        this.prefixStorage.put(Operation.class, "OP_");
        this.prefixStorage.put(EventTrigger.class, "EV_");
        this.prefixStorage.put(SituationEventTrigger.class, "SE_");
        this.prefixStorage.put(IntegrationStep.class, "IS_");
        this.prefixStorage.put(SituationStep.class, "SS_");
        this.prefixStorage.put(EmbeddedStep.class, "ES_");
        this.prefixStorage.put(Environment.class, "EN_");
        this.prefixStorage.put(Template.class, "TM_");
        this.prefixStorage.put(TriggerConfiguration.class, "TR_");
        this.prefixStorage.put(Server.class, "SV_");
        this.prefixStorage.put(SystemParsingRule.class, "SPR_");
        this.prefixStorage.put(OperationParsingRule.class, "OPR_");
        this.prefixStorage.put(TcContext.class, "CT_");
        this.prefixStorage.put(DataSetList.class, "DS_");
        this.prefixStorage.put(Folder.class, "FL_");
        this.prefixStorage.put(TransportConfiguration.class, "TT_");
        this.prefixStorage.put(LinkCollectorConfiguration.class, "LC_");
        this.prefixStorage.put(CallChain.class, "CH_");
        this.prefixStorage.put(IntegrationConfig.class, "IC_");
        this.prefixStorage.put(Storable.class, "UK_");
    }

    @Override
    public Object getPrefix(Class<? extends Storable> clazz) {
        String prefix = this.prefixStorage.get(clazz);
        if (prefix == null) {
            for (Map.Entry<Class<? extends Storable>, String> entry : this.prefixStorage.entrySet()) {
                if (!clazz.isAssignableFrom(entry.getKey()) && !entry.getKey().isAssignableFrom(clazz)) continue;
                return entry.getValue();
            }
        }
        return prefix;
    }

    @Override
    public Object getPrefix(Storable object) {
        return this.getPrefix(object.getClass());
    }

    @Override
    public Class<? extends Storable> getClassByPrefix(Object prefix) {
        for (Map.Entry<Class<? extends Storable>, String> entry : this.prefixStorage.entrySet()) {
            if (!entry.getValue().equals(prefix)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Prefix " + prefix + " is not bound to any class.");
    }

    @Override
    public Object removePrefix(Object id) {
        return id.toString().substring(3);
    }
}

