/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.hazelcast.instance;

import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.core.CoreConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"hibernate.second.level.cache.enabled"}, havingValue="true")
public class HazelcastInstanceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastInstanceConfig.class);
    @Value(value="${eureka.client.serviceUrl.defaultZone}")
    private String eurekaUrl;
    @Value(value="${hazelcast.cache.enabled:false}")
    private boolean hazelcastCacheEnabled;

    @Bean(name={"instanceConfig"})
    public Config getConfig() {
        Config config = new Config();
        config.setInstanceName(CoreConstants.HIBERNATE_CACHE_HAZELCAST_INSTANCE_NAME.stringValue());
        if (this.hazelcastCacheEnabled) {
            config.setProperty("hazelcast.phone.home.enabled", "false");
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            config.getNetworkConfig().getRestApiConfig().setEnabled(true);
            EurekaConfig eurekaConfig = config.getNetworkConfig().getJoin().getEurekaConfig();
            eurekaConfig.setEnabled(true);
            eurekaConfig.setProperty("self-registration", "true");
            eurekaConfig.setProperty("namespace", CoreConstants.HIBERNATE_CACHE_HAZELCAST_INSTANCE_EUREKA_CONFIG_NAMESPACE.stringValue());
            eurekaConfig.setProperty("use-classpath-eureka-client-props", "false");
            eurekaConfig.setProperty("shouldUseDns", "false");
            eurekaConfig.setProperty("name", CoreConstants.HIBERNATE_CACHE_HAZELCAST_INSTANCE_EUREKA_CONFIG_NAME.stringValue());
            eurekaConfig.setProperty("serviceUrl.default", this.eurekaUrl);
        } else {
            config.setClusterName("local-itf-hazelcast-cluster");
        }
        config.addCacheConfig(this.initBigRegionCache("projectsCache", 300, 12, TimeUnit.HOURS));
        config.addCacheConfig(this.initBigRegionCache("configurationsCache", 300000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("parsingRulesCache", 80000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("keysToRegenerateCache", 15000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("stepContainersCache", 50000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("eventTriggerCache", 30000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("conditionPropsCache", 60000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("operationParsingRulesCache", 70000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("systemParsingRulesCache", 10000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("templateCache", 35000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("operationTemplateCache", 30000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("systemTemplateCache", 5000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("outboundTransportConfigurationCache", 30000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("outboundTransportConfigurationsCollectionCache", 30000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("outboundTemplateTransportConfigurationsCollectionCache", 70000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("systemParsingRulesCollectionCache", 7000, 60, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("operationParsingRulesCollectionCache", 70000, 60, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("activeOperationEventTriggersCache", 30000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("operationByDefinitionKeyCache", 20000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("operationSituationsCollectionCache", 30000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("systemTransportsCollectionCache", 4000, 120, TimeUnit.MINUTES));
        config.addCacheConfig(this.initBigRegionCache("simpleSystemListByProjectCache", 500, 240, TimeUnit.MINUTES));
        Map cacheConfigs = config.getCacheConfigs();
        LOGGER.info("CacheConfigs - {} entries", (Object)cacheConfigs.size());
        for (Map.Entry cfg : cacheConfigs.entrySet()) {
            LOGGER.info("CacheConfig: {}: \n   EvictionConfig {}\n   ExpiryPolicyFactoryConfig {}", new Object[]{cfg.getKey(), ((CacheSimpleConfig)cfg.getValue()).getEvictionConfig(), ((CacheSimpleConfig)cfg.getValue()).getExpiryPolicyFactoryConfig()});
        }
        return config;
    }

    @Bean(name={"hazelcastCacheInstance"})
    public HazelcastInstance getHazelcastInstance(@Qualifier(value="instanceConfig") Config config) {
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    private CacheSimpleConfig initBigRegionCache(String cacheName, int cacheSize, int durationAmount, TimeUnit durationTimeUnit) {
        EvictionConfig evictionConfig = new EvictionConfig();
        evictionConfig.setEvictionPolicy(EvictionPolicy.LRU);
        evictionConfig.setMaxSizePolicy(MaxSizePolicy.ENTRY_COUNT);
        evictionConfig.setSize(cacheSize);
        CacheSimpleConfig cacheConfig = new CacheSimpleConfig();
        cacheConfig.setName(cacheName);
        cacheConfig.setEvictionConfig(evictionConfig);
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig((long)durationAmount, durationTimeUnit);
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig(CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ACCESSED, durationConfig);
        CacheSimpleConfig.ExpiryPolicyFactoryConfig expiryConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig(timedExpiryConfig);
        cacheConfig.setExpiryPolicyFactoryConfig(expiryConfig);
        return cacheConfig;
    }
}

