/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.helper;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.qubership.automation.itf.core.util.annotation.UserName;
import org.qubership.automation.itf.core.util.helper.Reflection;
import org.reflections.Reflections;

public class ClassResolver {
    private Map<String, Map<String, String>> classNameWithUserNameCache = new HashMap<String, Map<String, String>>();
    private Reflections reflections = Reflection.getReflections();

    public static ClassResolver getInstance() {
        return ClassResolverCacheHolder.instance;
    }

    public Map<String, String> resolveByInterface(Class clazz) {
        Map<String, String> classNameWithUserName = this.classNameWithUserNameCache.get(clazz.getName());
        if (classNameWithUserName != null) {
            return classNameWithUserName;
        }
        classNameWithUserName = new HashMap<String, String>();
        Set<Class> subClasses = this.getSubtypesOf(clazz);
        for (Class subClass : subClasses) {
            if (Modifier.isAbstract(subClass.getModifiers())) continue;
            if (subClass.isAnnotationPresent(UserName.class)) {
                classNameWithUserName.put(subClass.getName(), subClass.getAnnotation(UserName.class).value());
                continue;
            }
            classNameWithUserName.put(subClass.getName(), subClass.getSimpleName());
        }
        if (!classNameWithUserName.isEmpty()) {
            this.classNameWithUserNameCache.put(clazz.getName(), classNameWithUserName);
        }
        return classNameWithUserName;
    }

    private ClassResolver() {
    }

    public Set<Class> getSubtypesOf(Class clazz) {
        return this.reflections.getSubTypesOf(clazz);
    }

    public Set<Class> getSubtypesOf(Class clazz, Reflections reflections) {
        return reflections.getSubTypesOf(clazz);
    }

    private static class ClassResolverCacheHolder {
        private static final ClassResolver instance = new ClassResolver();

        private ClassResolverCacheHolder() {
        }
    }
}

