/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.helper;

import com.google.common.collect.Maps;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.exception.ContentException;
import org.qubership.automation.itf.core.util.parser.ParsingRuleType;
import org.qubership.automation.itf.core.util.provider.content.JsonContentProvider;
import org.qubership.automation.itf.core.util.provider.content.MessageContentProvider;
import org.qubership.automation.itf.core.util.provider.content.XmlContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentHelper.class);
    private static ContentHelper instance = new ContentHelper();
    private final Map<String, MessageContentProvider<?>> providers = Maps.newHashMapWithExpectedSize((int)3);

    public static ContentHelper getInstance() {
        return instance;
    }

    private ContentHelper() {
        this.initDefault();
    }

    private void initDefault() {
        this.providers.put(ParsingRuleType.XPATH.toString(), new XmlContentProvider());
        this.providers.put(ParsingRuleType.JSON_PATH.toString(), new JsonContentProvider());
    }

    public void registerProvider(String parsingRuleType, MessageContentProvider<?> provider) {
        this.providers.put(parsingRuleType, provider);
    }

    public void trySetContent(Message message, String parsingRuleType) throws ContentException {
        MessageContentProvider<?> provider;
        if (message.getContent() == null && (provider = this.providers.get(parsingRuleType)) != null && provider.supports(message)) {
            message.setContent(provider.provide(message));
        }
    }

    public boolean tryForContentType(Class<?> requestedContentType, Message message) {
        return message.getContent() != null && requestedContentType.isAssignableFrom((Class)((ParameterizedType)message.getContent().getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]);
    }
}

