/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.helper;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Striped;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.environment.InboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.environment.OutboundTransportConfiguration;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.converter.PropertiesConverter;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.exception.TransportException;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.transport.access.AccessOutboundTransport;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerUtils.class);
    private static final Striped<ReadWriteLock> SERVER_LOCKS = Striped.lazyWeakReadWriteLock((int)256);

    public static ConnectionProperties calculate(@Nonnull Server server, @Nonnull System receiver, @Nonnull TransportConfiguration configuration, @Nonnull Message message, Template template) throws TransportException {
        String typeName = configuration.getTypeName();
        OutboundTransportConfiguration out = server.getOutbound(receiver, typeName);
        return PropertiesConverter.convert(typeName, configuration, out, message.getTransportProperties(), template.getTransportProperties(typeName));
    }

    public static ConnectionProperties calculate(@Nonnull Server server, @Nonnull System receiver, @Nonnull TransportConfiguration configuration, @Nonnull Message message, Template template, InstanceContext instanceContext) throws TransportException {
        String typeName = configuration.getTypeName();
        OutboundTransportConfiguration out = server.getOutbound(receiver, typeName);
        return PropertiesConverter.convert(instanceContext, typeName, configuration, out, message.getTransportProperties(), template.getTransportProperties(typeName));
    }

    public static Server syncOutbounds(@Nonnull Server server, @Nonnull System system) {
        return ServerUtils.syncOutbounds(server, Collections.singleton(system));
    }

    public static Server syncOutbounds(@Nonnull Server server, @Nonnull Iterable<? extends System> systems) {
        Map<String, AccessTransport> transports;
        try {
            transports = TransportRegistryManager.getInstance().getTransports();
        }
        catch (TransportException e) {
            LOGGER.error("Can not sync outbounds", (Throwable)e);
            return server;
        }
        Server actualServer = server;
        final Object serverId = server.getID();
        final ObjectManager<Server> serverObjectManager = CoreObjectManager.getInstance().getManager(Server.class);
        for (Map.Entry<String, AccessTransport> entry : transports.entrySet()) {
            ReadWriteLock lock;
            Server actual;
            String typeName;
            ImmutableCollection<? extends System> unregistered;
            if (!(entry.getValue() instanceof AccessOutboundTransport) || (unregistered = ServerUtils.doRead(new Callable<ImmutableCollection<? extends System>>(typeName = entry.getKey(), systems, actual = actualServer){
                final /* synthetic */ String val$typeName;
                final /* synthetic */ Iterable val$systems;
                final /* synthetic */ Server val$actual;
                {
                    this.val$typeName = string;
                    this.val$systems = iterable;
                    this.val$actual = server;
                }

                @Override
                public ImmutableCollection<? extends System> call() throws Exception {
                    return ServerUtils.filterRegistered(this.val$typeName, this.val$systems, this.val$actual);
                }
            }, lock = (ReadWriteLock)SERVER_LOCKS.get((Object)server))).isEmpty()) continue;
            actualServer = ServerUtils.doWrite(new Callable<Server>(){

                @Override
                public Server call() throws Exception {
                    return ServerUtils.fillUnregistered(serverId, serverObjectManager, typeName, (ImmutableCollection<? extends System>)unregistered);
                }
            }, lock);
        }
        return actualServer;
    }

    public static Server syncInbounds(@Nonnull Server server, @Nonnull System system) {
        return ServerUtils.syncInbounds(server, Collections.singleton(system));
    }

    public static Server syncInbounds(final @Nonnull Server server, final @Nonnull Iterable<? extends System> systems) {
        ReadWriteLock lock = (ReadWriteLock)SERVER_LOCKS.get((Object)server);
        final ImmutableCollection<TransportConfiguration> unregistered = ServerUtils.doRead(new Callable<ImmutableCollection<TransportConfiguration>>(){

            @Override
            public ImmutableCollection<TransportConfiguration> call() throws Exception {
                return ServerUtils.filterRegistered(server, systems);
            }
        }, lock);
        if (unregistered.isEmpty()) {
            return server;
        }
        final ObjectManager<Server> serverObjectManager = CoreObjectManager.getInstance().getManager(Server.class);
        return ServerUtils.doWrite(new Callable<Server>(){

            @Override
            public Server call() throws Exception {
                return ServerUtils.fillUnregistered(server.getID(), serverObjectManager, (Collection)unregistered);
            }
        }, lock);
    }

    private static Server fillUnregistered(Object serverId, ObjectManager<Server> serverObjectManager, Collection<TransportConfiguration> unregistered) {
        Server server = serverObjectManager.getById(serverId);
        unregistered = ServerUtils.filterRegistered(server, unregistered);
        if (!unregistered.isEmpty()) {
            Collection<InboundTransportConfiguration> inbounds = server.getInbounds();
            for (TransportConfiguration config : unregistered) {
                inbounds.add(new InboundTransportConfiguration(config, server));
            }
            server.store();
        }
        return server;
    }

    private static Server fillUnregistered(Object serverId, ObjectManager<Server> serverObjectManager, String typeName, ImmutableCollection<? extends System> unregistered) {
        Server server = serverObjectManager.getById(serverId);
        if (!(unregistered = ServerUtils.filterRegistered(typeName, unregistered, server)).isEmpty()) {
            Collection<OutboundTransportConfiguration> outbounds = server.getOutbounds();
            for (System system : unregistered) {
                outbounds.add(new OutboundTransportConfiguration(typeName, server, system));
            }
            server.store();
        }
        return server;
    }

    private static ImmutableCollection<TransportConfiguration> filterRegistered(final Server where, Collection<TransportConfiguration> configs) {
        return FluentIterable.from(configs).filter((Predicate)new Predicate<TransportConfiguration>(){

            public boolean apply(TransportConfiguration input) {
                if (input == null) {
                    return false;
                }
                Mep mep = input.getMep();
                return mep.isInbound() && mep.isRequest() && !ServerUtils.containsInbound(where, input);
            }
        }).toList();
    }

    private static ImmutableCollection<? extends System> filterRegistered(final String typeName, Iterable<? extends System> allSystems, final Server server) {
        return FluentIterable.from(allSystems).filter((Predicate)new Predicate<System>(){

            public boolean apply(System input) {
                return !ServerUtils.containsOutbound(server.getOutbounds(), input, typeName);
            }
        }).toList();
    }

    private static ImmutableCollection<TransportConfiguration> filterRegistered(Server where, Iterable<? extends System> systems) {
        Iterable configs = Iterables.concat((Iterable)FluentIterable.from(systems).transform((Function)new Function<System, Iterable<TransportConfiguration>>(){

            public Iterable<TransportConfiguration> apply(System input) {
                return input == null ? new HashSet() : input.getTransports();
            }
        }));
        return ServerUtils.filterRegistered(where, (Collection<TransportConfiguration>)ImmutableList.copyOf((Iterable)configs));
    }

    private static boolean containsInbound(Server who, final TransportConfiguration what) {
        return Iterables.tryFind(who.getInbounds(), (Predicate)new Predicate<InboundTransportConfiguration>(){

            public boolean apply(InboundTransportConfiguration input) {
                return input != null && what.equals(input.getReferencedConfiguration());
            }
        }).isPresent();
    }

    private static boolean containsOutbound(Collection<OutboundTransportConfiguration> in, final System what, final String typeName) {
        return Iterables.tryFind(in, (Predicate)new Predicate<OutboundTransportConfiguration>(){

            public boolean apply(OutboundTransportConfiguration input) {
                return input != null && what.equals(input.getSystem()) && typeName.equals(input.getTypeName());
            }
        }).isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doRead(Callable<T> callable, ReadWriteLock lock) {
        Lock readLock = lock.readLock();
        readLock.lock();
        try {
            T t = TxExecutor.executeUnchecked(callable, TxExecutor.readOnlyTransaction());
            return t;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doWrite(Callable<T> callable, ReadWriteLock lock) {
        Lock writeLock = lock.writeLock();
        writeLock.lock();
        try {
            T t = TxExecutor.executeUnchecked(callable, TxExecutor.nestedWritableTransaction());
            return t;
        }
        finally {
            writeLock.unlock();
        }
    }
}

