/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.holder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.util.annotation.ApplyToTransport;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.loader.InterceptorClassLoader;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptorHolder.class);
    private Map<String, Map<String, Class<?>>> interceptors = new HashMap();

    public static InterceptorHolder getInstance() {
        return InterceptorHolderInstance.INSTANCE;
    }

    private InterceptorHolder() {
        this.fillInterceptorHolder();
    }

    public void fillInterceptorHolder() {
        File interceptorsFolder;
        File[] interceptorFiles;
        String interceptorFolderPath = ApplicationConfig.env.getProperty("interceptors.folder");
        if (!StringUtils.isEmpty((CharSequence)interceptorFolderPath) && (interceptorFiles = (interceptorsFolder = new File(interceptorFolderPath)).listFiles()) != null && interceptorFiles.length > 0) {
            List<URL> commonJars = this.getCommonJars(interceptorFiles);
            for (File interceptorFile : interceptorFiles) {
                File[] interceptorsFiles;
                if (!interceptorFile.isDirectory() || (interceptorsFiles = interceptorFile.listFiles()) == null) continue;
                this.loadInterceptorWithDependencies(interceptorsFiles, interceptorFile.getName(), commonJars);
            }
        }
    }

    public void clearInterceptorHolder() {
        this.interceptors.clear();
    }

    public Map<String, Map<String, Class<?>>> getInterceptors() {
        return this.interceptors;
    }

    private void loadInterceptorWithDependencies(File[] interceptorsFiles, String interceptorDirectoryName, List<URL> commonJars) {
        List<URL> urls = this.getUrls(interceptorsFiles, true);
        urls.addAll(commonJars);
        if (!urls.isEmpty()) {
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
            Set<Class<? extends TransportInterceptor>> interceptorClasses = this.getInterceptorClasses(classLoader);
            if (interceptorClasses.isEmpty()) {
                LOGGER.warn("There is no interceptor in '{}' directory", (Object)interceptorDirectoryName);
            } else {
                for (Class<? extends TransportInterceptor> interceptorClass : interceptorClasses) {
                    InterceptorClassLoader.getInstance().getClassLoaderHolder().put(interceptorClass.getName(), classLoader);
                    this.addInterceptorToInterceptorHolder(classLoader, interceptorClass.getName());
                }
            }
        }
    }

    private List<URL> getUrls(File[] interceptorsFiles, boolean withChildren) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (interceptorsFiles != null) {
            for (File interceptorFile : interceptorsFiles) {
                if (interceptorFile.isDirectory()) {
                    if (!withChildren) continue;
                    urls.addAll(this.getUrls(interceptorFile.listFiles(), false));
                    continue;
                }
                try {
                    urls.add(interceptorFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Can't get URL of '{}' file", (Object)interceptorFile.getName());
                }
            }
        }
        return urls;
    }

    private Set<Class<? extends TransportInterceptor>> getInterceptorClasses(ClassLoader classLoader) {
        Reflections reflections = new Reflections(new Object[]{"org.qubership", classLoader});
        return reflections.getSubTypesOf(TransportInterceptor.class);
    }

    private void addInterceptorToInterceptorHolder(ClassLoader classLoader, String className) {
        try {
            Class<?> resolvedClass = classLoader.loadClass(className);
            ApplyToTransport applyToTransports = resolvedClass.getAnnotation(ApplyToTransport.class);
            Named name = resolvedClass.getAnnotation(Named.class);
            if (applyToTransports != null) {
                for (String transportName : applyToTransports.transports()) {
                    Map<String, Class<?>> interceptorInfo = this.interceptors.get(transportName);
                    if (interceptorInfo == null) {
                        interceptorInfo = new HashMap();
                    }
                    interceptorInfo.put(name.value(), resolvedClass);
                    this.interceptors.put(transportName, interceptorInfo);
                }
                LOGGER.info("'{}' interceptor is registered successfully", (Object)name.value());
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot load '{}' class. Interceptor isn't registered.", (Object)className, (Object)e);
        }
    }

    private List<URL> getCommonJars(File[] interceptorFiles) {
        ArrayList<URL> commonJarsUrls = new ArrayList<URL>();
        for (File file : interceptorFiles) {
            if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
            try {
                commonJarsUrls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOGGER.error("Can't get URL of {} file", (Object)file.getName(), (Object)e);
            }
        }
        return commonJarsUrls;
    }

    public static class InterceptorHolderInstance {
        public static final InterceptorHolder INSTANCE = new InterceptorHolder();
    }
}

