/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.iterator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.util.iterator.AbstractStepIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallChainStepIterator
extends AbstractStepIterator {
    public static final Logger LOGGER = LoggerFactory.getLogger(CallChainStepIterator.class);

    public CallChainStepIterator(CallChain callChain, AbstractContainerInstance parent) {
        ArrayList steps = Lists.newArrayList();
        this.getAllSteps(callChain, steps);
        this.setIterator(steps.iterator());
        this.setParent(parent);
    }

    public CallChainStepIterator(CallChain callChain, AbstractContainerInstance parent, List<Step> steps) {
        this.setIterator(steps.iterator());
        this.setParent(parent);
    }

    private void getAllSteps(CallChain callChain, List<Step> stepList) {
        for (Step step : callChain.getSteps()) {
            if (step == null) continue;
            if (!step.isEnabled()) {
                LOGGER.debug("Call chain step '{}' is disabled ==> step is skipped.", (Object)step);
                continue;
            }
            if (step instanceof SituationStep) {
                if (((SituationStep)step).getSituation() == null) {
                    LOGGER.debug("Call chain step '{}': situation is null ==> step is skipped.", (Object)step);
                    continue;
                }
            } else if (step instanceof EmbeddedStep && ((EmbeddedStep)step).getChain() == null) {
                LOGGER.debug("Call chain step '{}': callchain is null ==> step is skipped.", (Object)step);
                continue;
            }
            stepList.add(step);
        }
    }
}

