/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.loader;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.util.loader.base.AbstractLoader;

public class InterceptorClassLoader
extends AbstractLoader<TransportInterceptor> {
    private static final InterceptorClassLoader INSTANCE = new InterceptorClassLoader();
    private final Map<String, ClassLoader> classLoaderHolder = Maps.newHashMapWithExpectedSize((int)10);

    public static InterceptorClassLoader getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<TransportInterceptor> getGenericType() {
        return TransportInterceptor.class;
    }

    @Override
    public TransportInterceptor getInstanceClass(String className, Object ... paramForConstructor) throws ClassNotFoundException {
        try {
            return this.getClass(className).getConstructor(Interceptor.class).newInstance(paramForConstructor);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassNotFoundException("Classloader not found for class", e);
        }
    }

    @Override
    public Class<? extends TransportInterceptor> getClass(String typeName) throws ClassNotFoundException {
        try {
            if (this.getClassLoaderHolder().containsKey(typeName)) {
                return this.getClassLoaderHolder().get(typeName).loadClass(typeName).asSubclass(TransportInterceptor.class);
            }
            throw new ClassNotFoundException("Classloader not found for class " + typeName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("CommonInterceptor with name " + typeName + " is not found in classloader", e);
        }
    }

    @Override
    @Deprecated
    public void cleanClassLoaders() {
        this.classLoaderHolder.clear();
    }

    @Override
    protected void validateClasses(Set<Class<? extends TransportInterceptor>> classes) {
        if (classes.size() > 1) {
            throw new IllegalArgumentException("More then one class found: " + classes);
        }
        if (!classes.iterator().hasNext()) {
            throw new IllegalArgumentException("No one class found");
        }
    }

    @Override
    public Map<String, ClassLoader> getClassLoaderHolder() {
        return this.classLoaderHolder;
    }
}

