/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.logger;

import ch.qos.logback.classic.Level;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ItfLogger
implements Logger {
    public static final String LOG_LEVEL = "log.level";
    private Logger logger;

    public static Logger getLogger(Class classLogger) {
        return new ItfLogger(LoggerFactory.getLogger((Class)classLogger));
    }

    private ItfLogger(Logger logger) {
        this.logger = logger;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isDebugEnabled() {
        return this.logLevelEnabled(Level.DEBUG);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg);
        }
    }

    public void debug(String msg, Object object) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg, object);
        }
    }

    public void debug(String msg, Object first, Object second) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg, first, second);
        }
    }

    public void debug(String msg, Object ... objects) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg, objects);
        }
    }

    public void debug(String msg, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg, throwable);
        }
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String msg, Object object) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, msg, object);
        }
    }

    public void debug(Marker marker, String msg, Object first, Object second) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, msg, first, second);
        }
    }

    public void debug(Marker marker, String msg, Object ... objects) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, msg, objects);
        }
    }

    public void debug(Marker marker, String msg, Throwable throwable) {
        if (this.isDebugEnabled(marker)) {
            this.logger.debug(marker, msg, throwable);
        }
    }

    public boolean isTraceEnabled() {
        return this.logLevelEnabled(Level.TRACE);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg);
        }
    }

    public void trace(String msg, Object object) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg, object);
        }
    }

    public void trace(String msg, Object first, Object second) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg, first, second);
        }
    }

    public void trace(String msg, Object ... objects) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg, objects);
        }
    }

    public void trace(String msg, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg, throwable);
        }
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String msg, Object object) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, msg, object);
        }
    }

    public void trace(Marker marker, String msg, Object first, Object second) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, msg, first, second);
        }
    }

    public void trace(Marker marker, String msg, Object ... objects) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, msg, objects);
        }
    }

    public void trace(Marker marker, String msg, Throwable throwable) {
        if (this.isTraceEnabled(marker)) {
            this.logger.trace(marker, msg, throwable);
        }
    }

    public boolean isInfoEnabled() {
        return this.logLevelEnabled(Level.INFO);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg);
        }
    }

    public void info(String msg, Object object) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg, object);
        }
    }

    public void info(String msg, Object first, Object second) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg, first, second);
        }
    }

    public void info(String msg, Object ... objects) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg, objects);
        }
    }

    public void info(String msg, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg, throwable);
        }
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, msg);
        }
    }

    public void info(Marker marker, String msg, Object object) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, msg, object);
        }
    }

    public void info(Marker marker, String msg, Object first, Object second) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, msg, first, second);
        }
    }

    public void info(Marker marker, String msg, Object ... objects) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, msg, objects);
        }
    }

    public void info(Marker marker, String msg, Throwable throwable) {
        if (this.isInfoEnabled(marker)) {
            this.logger.info(marker, msg, throwable);
        }
    }

    public boolean isWarnEnabled() {
        return this.logLevelEnabled(Level.WARN);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg);
        }
    }

    public void warn(String msg, Object object) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg, object);
        }
    }

    public void warn(String msg, Object ... objects) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg, objects);
        }
    }

    public void warn(String msg, Object first, Object second) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg, first, second);
        }
    }

    public void warn(String msg, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg, throwable);
        }
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, msg);
        }
    }

    public void warn(Marker marker, String msg, Object object) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, msg, object);
        }
    }

    public void warn(Marker marker, String msg, Object first, Object second) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, msg, first, second);
        }
    }

    public void warn(Marker marker, String msg, Object ... objects) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, msg, objects);
        }
    }

    public void warn(Marker marker, String msg, Throwable throwable) {
        if (this.isWarnEnabled(marker)) {
            this.logger.warn(marker, msg, throwable);
        }
    }

    public boolean isErrorEnabled() {
        return this.logLevelEnabled(Level.ERROR);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg);
        }
    }

    public void error(String msg, Object object) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg, object);
        }
    }

    public void error(String msg, Object first, Object second) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg, first, second);
        }
    }

    public void error(String msg, Object ... objects) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg, objects);
        }
    }

    public void error(String msg, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg, throwable);
        }
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, msg);
        }
    }

    public void error(Marker marker, String msg, Object object) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, msg, object);
        }
    }

    public void error(Marker marker, String msg, Object first, Object second) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, msg, first, second);
        }
    }

    public void error(Marker marker, String msg, Object ... objects) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, msg, objects);
        }
    }

    public void error(Marker marker, String msg, Throwable throwable) {
        if (this.isErrorEnabled(marker)) {
            this.logger.error(marker, msg, throwable);
        }
    }

    private boolean logLevelEnabled(Level level) {
        return level.toString().equals(ApplicationConfig.env.getProperty(LOG_LEVEL, "INFO").toUpperCase());
    }
}

