/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.manager;

import org.qubership.automation.itf.core.hibernate.ManagerFactory;
import org.qubership.automation.itf.core.hibernate.spring.managers.base.ObjectManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CoreObjectManagerService {
    private ManagerFactory managerFactory;

    @Autowired
    private CoreObjectManagerService(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    public ManagerFactory getManagerFactory() {
        return this.managerFactory;
    }

    public void setManagerFactory(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    public <U extends Storable> ObjectManager<U> managerFor(Class<U> clazz) {
        return this.getManager(clazz);
    }

    public <U extends Storable> ObjectManager<U> getManager(Class<U> clazz) {
        return this.managerFactory.getManager(clazz);
    }

    public <U extends Storable, T extends ObjectManager<U>> T getSpecialManager(Class<U> clazz, Class<T> toCast) {
        ObjectManager<U> manager = this.managerFactory.getManager(clazz);
        if (toCast.isAssignableFrom(manager.getClass())) {
            return (T)manager;
        }
        throw new IllegalArgumentException(String.format("Object manager %s is not of type %s", manager, toCast.getName()));
    }
}

