/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.manager;

import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.qubership.automation.itf.core.model.extension.Extendable;
import org.qubership.automation.itf.core.model.extension.ExtendableImpl;
import org.qubership.automation.itf.core.model.extension.Extension;
import org.qubership.automation.itf.core.util.exception.ExtensionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionManager
implements Serializable {
    private static final long serialVersionUID = 20240812L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionManager.class);
    private static ExtensionManager ourInstance = new ExtensionManager();

    private ExtensionManager() {
    }

    public static ExtensionManager getInstance() {
        return ourInstance;
    }

    public <T> T createExtendable(T object) throws ExtensionException {
        if (!(object instanceof Extendable)) {
            try {
                return (T)this.enhanceObject(object);
            }
            catch (Exception e) {
                throw new ExtensionException(String.format("Error creating extension for object %s", object), e);
            }
        }
        return object;
    }

    public <T> T createExtendable(Class<T> clazz) throws ExtensionException {
        if (!Extendable.class.isAssignableFrom(clazz)) {
            try {
                return (T)this.enhanceClass(clazz);
            }
            catch (Throwable e) {
                throw new ExtensionException(String.format("Error creating extension for class %s", clazz.getName()), e);
            }
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ExtensionException(String.format("Error creating instance of class %s", clazz.getName()), e);
        }
    }

    public void extend(Object object, Extension extension) {
        if (extension != null && object != null) {
            if (object instanceof Extendable) {
                Extendable extendable = (Extendable)object;
                extendable.extend(extension);
            } else {
                LOGGER.warn("Cannot extend unextendable object {}", object);
            }
        }
    }

    public <T extends Extension> T getExtension(Object object, Class<T> extensionClass) {
        if (object instanceof Extendable) {
            Object extension = ((Extendable)object).getExtension(extensionClass);
            if (extension == null) {
                try {
                    extension = (Extension)extensionClass.newInstance();
                    ((Extendable)object).extend((Extension)extension);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.warn("Error creating extension instance", (Throwable)e);
                    return null;
                }
            }
            return extension;
        }
        return null;
    }

    private Extendable enhanceObject(Object object) throws NoSuchMethodException {
        Class<?> clazz = object.getClass();
        clazz.getDeclaredConstructor(new Class[0]).setAccessible(true);
        Object enhanced = Enhancer.create(clazz, (Class[])new Class[]{Extendable.class}, (Callback)new ExtendedInvocationHandler(object));
        return (Extendable)enhanced;
    }

    private Extendable enhanceClass(Class clazz) throws NoSuchMethodException {
        clazz.getDeclaredConstructor(new Class[0]).setAccessible(true);
        Object enhanced = Enhancer.create((Class)clazz, (Class[])new Class[]{Extendable.class}, (Callback)new ExtendedSelfMethodInterceptor());
        return (Extendable)enhanced;
    }

    private static class ExtendedSelfMethodInterceptor
    implements MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = 20240812L;
        private final ExtendableImpl extendable = new ExtendableImpl();

        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            if (Extendable.class.isAssignableFrom(method.getDeclaringClass())) {
                return method.invoke((Object)this.extendable, objects);
            }
            return methodProxy.invokeSuper(o, objects);
        }
    }

    private static class ExtendedInvocationHandler
    implements InvocationHandler {
        private final Object object;
        private final ExtendableImpl extendable = new ExtendableImpl();

        public ExtendedInvocationHandler(Object object) {
            this.object = object;
        }

        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (Extendable.class.isAssignableFrom(method.getDeclaringClass())) {
                return method.invoke((Object)this.extendable, objects);
            }
            return method.invoke(this.object, objects);
        }
    }
}

