/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.provider.content;

import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.qubership.automation.itf.core.model.content.Content;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.exception.ContentException;
import org.qubership.automation.itf.core.util.provider.content.MessageContentProvider;

public class JsonContentProvider
implements MessageContentProvider<JSONObject> {
    @Override
    public Content<JSONObject> provide(Message message) throws ContentException {
        try {
            JSONParser parser = new JSONParser();
            return new JsonContent((JSONAware)parser.parse(message.getText()));
        }
        catch (ParseException e) {
            throw new ContentException("Cannot parse JSON in message", e);
        }
    }

    @Override
    public boolean supports(Message message) {
        if (message == null || StringUtils.isBlank((CharSequence)message.getText())) {
            return false;
        }
        String text = message.getText().trim();
        return text.startsWith("{") && text.endsWith("}") || text.startsWith("[") || text.endsWith("]");
    }

    private static class JsonContent
    implements Content<JSONObject> {
        private JSONObject object;

        private JsonContent(JSONAware object) throws ContentException {
            if (object instanceof JSONArray) {
                this.object = new JSONObject();
                this.object.put((Object)"array", (Object)object);
            } else if (object instanceof JSONObject) {
                this.object = (JSONObject)object;
            } else {
                throw new ContentException("Cannot take JSONObject from parsed object");
            }
        }

        @Override
        public JSONObject get() {
            return this.object;
        }
    }
}

