/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.provider.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.qubership.automation.itf.core.model.content.Content;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.util.exception.ContentException;
import org.qubership.automation.itf.core.util.provider.content.MessageContentProvider;

public class XmlContentProvider
implements MessageContentProvider<Element> {
    @Override
    public Content<Element> provide(Message message) throws ContentException {
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringBoundaryWhitespace(true);
        ByteArrayInputStream stream = new ByteArrayInputStream(message.getText().getBytes(StandardCharsets.UTF_8));
        try {
            return new XmlContent(builder.build((InputStream)stream).getRootElement());
        }
        catch (JDOMException e) {
            throw new ContentException("Cannot parse XML in message", e);
        }
        catch (IOException e) {
            throw new ContentException("Cannot load content", e);
        }
    }

    @Override
    public boolean supports(Message message) {
        if (message == null || message.getText() == null) {
            return false;
        }
        return message.getText().trim().startsWith("<");
    }

    private static class XmlContent
    implements Content<Element> {
        private Element element;

        XmlContent(Element element) {
            this.element = element;
        }

        @Override
        public Element get() {
            return this.element;
        }
    }
}

