/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.report;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.EnvironmentObjectManager;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.report.LinkCollectorConfiguration;
import org.qubership.automation.itf.core.util.descriptor.Extractor;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.report.LinkCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportLinkCollector {
    private static final Logger log = LoggerFactory.getLogger(ReportLinkCollector.class);
    private Map<String, LinkCollector> collectors = Maps.newConcurrentMap();
    private org.springframework.core.env.Environment env;
    private final LoadingCache<String, String> urls = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(@NotNull String key) {
            return ReportLinkCollector.this.env.getProperty(key);
        }
    });
    private static final LoadingCache<BigInteger, Set<LinkCollectorConfiguration>> CONF_CACHE = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BigInteger, Set<LinkCollectorConfiguration>>(){

        public Set<LinkCollectorConfiguration> load(@Nonnull BigInteger id) {
            try {
                HashSet result = CoreObjectManager.getInstance().getSpecialManager(Environment.class, EnvironmentObjectManager.class).getLinkCollectorsByEnvId(id);
                return result == null ? new HashSet() : result;
            }
            catch (Throwable anyException) {
                return new HashSet<LinkCollectorConfiguration>();
            }
        }
    });

    private ReportLinkCollector() {
    }

    @Autowired
    public ReportLinkCollector(org.springframework.core.env.Environment env) {
        this.env = env;
    }

    public void cacheCleanup() {
        CONF_CACHE.cleanUp();
    }

    public Map<String, String> collect(TcContext tcContext) {
        HashMap links = Maps.newHashMapWithExpectedSize((int)this.collectors.size());
        try {
            for (Map.Entry<String, LinkCollector> entry : this.collectors.entrySet()) {
                if (!entry.getValue().common()) continue;
                Pair<String, String> pair = entry.getValue().collect(tcContext, null);
                links.put(pair.getLeft(), Strings.nullToEmpty((String)((String)pair.getRight())));
            }
            Set reportCollectors = (Set)CONF_CACHE.get((Object)tcContext.getEnvironmentId());
            for (LinkCollectorConfiguration configuration : reportCollectors) {
                Pair<String, String> pair;
                LinkCollector collector = this.collectors.computeIfAbsent(configuration.getTypeName(), key -> {
                    try {
                        return Class.forName(key).asSubclass(LinkCollector.class).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        log.error("Error initializing link collector for {}: ", key, (Object)e);
                        return null;
                    }
                });
                if (collector == null || !collector.getClass().getName().equals(configuration.getTypeName()) || ((String)(pair = collector.collect(tcContext, configuration)).getValue()).startsWith("unknownhost")) continue;
                links.put(pair.getLeft(), Strings.nullToEmpty((String)((String)pair.getRight())));
            }
        }
        catch (Exception e) {
            log.error("Error collecting link...", (Throwable)e);
        }
        tcContext.getReportLinks().putAll(links);
        return links;
    }

    public void registerCollector(LinkCollector collector) {
        this.collectors.put(collector.getClass().getName(), collector);
    }

    public void registerCollector(Class<? extends LinkCollector> collectorClass) {
        this.collectors.computeIfAbsent(collectorClass.getName(), key -> {
            try {
                return (LinkCollector)collectorClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error("Error while registering collector class {}: ", (Object)collectorClass, (Object)e);
                return null;
            }
        });
    }

    public void registerCollectors(Collection<String> classNames) {
        for (String className : classNames) {
            try {
                this.registerCollector(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                log.error("Collector class {} not found", (Object)className);
            }
        }
    }

    public void unregisterCollector(LinkCollector collector) {
        this.collectors.remove(collector.getClass().getName());
    }

    public void unregisterCollectors(Class<? extends LinkCollector> collectorClass) {
        this.collectors.remove(collectorClass.getName());
    }

    public Collection<PropertyDescriptor> getProperties(String className) {
        return Extractor.extractProperties(this.collectors.get(className));
    }

    public String getLinkToObject(BigInteger projectId, UUID projectUuid, Object objectId, String endpoint, boolean standalone) {
        return standalone ? (String)this.urls.getUnchecked((Object)"configurator.url") + "/project/" + projectId + endpoint + objectId : (String)this.urls.getUnchecked((Object)"atp.catalogue.url") + "/project/" + projectUuid + "/itf" + endpoint + objectId;
    }
}

